/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.sci;

import java.io.File;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.db.MySql;
import org.rhwlab.grid.GridSubmit;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.GridSubmittable;

/**
 *
 * @author gevirl
 */
public class SequencingID extends TextCell implements GridSubmittable{
    public SequencingID(){
        super();
        inputs.put("SampleID",null);
        inputs.put("SourceDirectory",null);
        inputs.put("ArchiveDirectory",null);
        inputs.put("ArchiveSubmitted",null);
        inputs.put("ArchiveCompleted",null);
        inputs.put("rtBarcodeFile",null);
        inputs.put("UMIattachSubmitted",null);
        inputs.put("UMIattachCompleted",null);  
        inputs.put("UMIattachDirectory",null); 
    }
    public void stateChanged(ChangeEvent event){
        String unique = ((CellBase)event.getSource()).getValueAsString();
        String sample = inputs.get("SampleID").getValueAsString();
        if (sample.equals(""))return;

        this.setValue(String.format("%s_%s", sample,unique));
    }  

    @Override
    public void submit(String program, int cores, int memory, int hours, String queue, String arrayjob, int concurrent) throws Exception {
        String sourceDir = inputs.get("SourceDirectory").getValueAsString();
        if (program.equals("Archive")){
            
            if (sourceDir.equals("")) {
                JOptionPane.showMessageDialog(panel, "Enter the source directory to archive");
                return;
            }
            File sourceDirFile = new File(sourceDir);
            if (!sourceDirFile.exists()){
                JOptionPane.showMessageDialog(panel, String.format("Cannot find file: %s",sourceDir));
                return;
            }
            if (!sourceDirFile.isDirectory()){
                JOptionPane.showMessageDialog(panel, String.format("%s is not a directory",sourceDir));
            }
            submitArchive(sourceDir,cores,memory,hours,queue);
        }
        else if (program.equals("UMIattach")){
            submitUMIattach(sourceDir,cores,memory,hours,queue);
        }
    }
    private void submitUMIattach(String sourceDir,int cores, int memory, int hours, String queue)throws Exception {
        inputs.get("UMIattachSubmitted").setValue(new Date());  
        inputs.get("UMIattachCompleted").setValue(null);    
        String sequencingID = this.getValueAsString();
        
        String archiveDir = inputs.get("ArchiveDirectory").getValueAsString();
        File archiveDirFile = new File(archiveDir);
        
        // make the UMI dir
        String UMIattachDir = inputs.get("UMIattachDirectory").getValueAsString();
        
        ProcessBuilder pb = new ProcessBuilder("mkdir","-p",UMIattachDir);
        Process p = pb.start();
        p.waitFor();
        
        GridSubmit gs = new GridSubmit(sequencingID,"UMIattach",archiveDirFile);
        gs.setRuntime(hours);
        gs.setMemory(memory);
        gs.setSlots(cores);
        gs.setQueue(queue);
        PrintWriter qsubStream = gs.initializeQsub();  
        ArrayList<String> args = new ArrayList<>();
        args.add(sourceDir);
        args.add(inputs.get("rtBarcodeFile").getValueAsString());
        args.add(UMIattachDir);
        args.add(sequencingID);
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.sci.UMI_attach", args);
        gs.run();
    }    
    private void submitArchive(String sourceDir,int cores, int memory, int hours, String queue)throws Exception {
        inputs.get("ArchiveSubmitted").setValue(new Date());  
        inputs.get("ArchiveCompleted").setValue(null);
        
        String sequencingID = this.getValueAsString();
        
        // make the sequencing archive directory
        String archiveDir = inputs.get("ArchiveDirectory").getValueAsString();
        File dirFile = new File(archiveDir);
        File archiveFile = new File(dirFile,"archiveFastq.tar");
        
        ProcessBuilder pb = new ProcessBuilder("mkdir","-p",archiveDir);
        Process p = pb.start();
        p.waitFor();
        
        GridSubmit gs = new GridSubmit(sequencingID,"Archive",dirFile);
        gs.setRuntime(hours);
        gs.setMemory(memory);
        gs.setSlots(cores);
        gs.setQueue(queue);
        PrintWriter qsubStream = gs.initializeQsub(); 
        
        qsubStream.printf("rm -f %s\n",archiveFile.getPath());
        qsubStream.printf("tar -c -f %s %s/* \n",archiveFile.getPath(),sourceDir);
        qsubStream.printf("chmod 444 %s \n",archiveFile.getPath());
        
        ArrayList<String> args = new ArrayList<>();
        args.add(sequencingID);
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.sci.SequencingID", args);
        gs.run();
    }
    
    static public void main(String[] args)throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("update sciSequencing set ArchivingCompleted = ? where SequencingID = ?");
        state.setTimestamp(1, new Timestamp(new java.util.Date().getTime()));
        state.setString(2, args[0]);
        state.execute();        
    }
}
