/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.sci;

import java.io.File;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.RNASeq.AlignReference;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.db.MySql;
import org.rhwlab.grid.GridSubmit;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.GridSubmittable;

/**
 *
 * @author gevirl
 */
public class SampleID extends TextCell  implements GridSubmittable{
    public SampleID(){
        super();
        inputs.put("SampleDirectory",null);
        inputs.put("DupRemoveDirectory",null);
        inputs.put("SampleName",null);
        inputs.put("DupRemovedSubmitted",null);
        inputs.put("DupRemovedCompleted",null);
        inputs.put("SplitSubmitted",null);
        inputs.put("SplitCompleted",null); 
        inputs.put("GeneCountSubmitted",null);
        inputs.put("GeneCountCompleted",null);     
        inputs.put("rtBarcodeFile",null); 
        inputs.put("Cutoff",null);  
        inputs.put("SampleIDFile", null);
        inputs.put("Reference", null);
    }
    public void stateChanged(ChangeEvent event){
        String unique = ((CellBase)event.getSource()).getValueAsString();
        String sample = inputs.get("SampleName").getValueAsString();
        if (sample.equals(""))return;

        this.setValue(String.format("%s_%s", sample,unique));
    }    

    // find all the active alignments for this sample
    public List<String> activeAlignments()throws Exception {
        ArrayList<String> aligns = new ArrayList<>();
        PreparedStatement state = MySql.getMySql().getStatement
        ("SELECT * FROM sciAlignment A join LMSTracking T on A.AlignmentID=T.ID where A.SampleID = ? and T.Status = ? and T.Project = ? and T.DBTable = ?");
        state.setString(1, this.getValueAsString());
        state.setString(2, "Active");
        state.setString(3, "SingleCell");
        state.setString(4, "sciAlignment");
        ResultSet rs = state.executeQuery();
        while(rs.next()){
            aligns.add(rs.getString("AlignmentID"));
        }
        return aligns;
    }
    
    @Override
    public void submit(String program, int cores, int memory, int hours, String queue, String arrayjob, int concurrent) throws Exception {
        String sampleDir = inputs.get("SampleDirectory").getValueAsString();
        File sampleDirFile = new File(sampleDir);
        String sampleID = this.getValueAsString();
        
        ProcessBuilder pb = new ProcessBuilder("mkdir","-p",sampleDir);
        Process p = pb.start();
        p.waitFor();
        
        File mergedDir = new File(sampleDir,"Merged");
        pb = new ProcessBuilder("mkdir","-p",mergedDir.getPath());
        p = pb.start();
        p.waitFor(); 
            
        GridSubmit gs = new GridSubmit(sampleID,program,sampleDirFile);
        gs.setRuntime(hours);
        gs.setMemory(memory);
        gs.setSlots(cores);
        gs.setQueue(queue);
        PrintWriter qsubStream = gs.initializeQsub();     
        
        if (program.equals("DupRemove")){
            String dupRemoveDir = inputs.get("DupRemoveDirectory").getValueAsString();
            pb = new ProcessBuilder("mkdir","-p",dupRemoveDir);
            p = pb.start();
            p.waitFor();  
            
            List<String> alignIDs = this.activeAlignments();
            if (alignIDs.isEmpty()) return;
            
            ArrayList<String> filterDirs = new ArrayList<>();
            for (String alignID : alignIDs){
                filterDirs.add(FilterDirectory.getDirectory(alignID));
            }            
            // get all the sample file names
            File[] files = new File(filterDirs.get(0)).listFiles();
            ArrayList<String> sampleFileNames = new ArrayList<>();
            for (File file : files){
                if (file.getName().endsWith("bam")){
                    sampleFileNames.add(file.getName());
                }
            }
            
            inputs.get("DupRemovedSubmitted").setValue(new Date());  
            inputs.get("DupRemovedCompleted").setValue(null);
            
            qsubStream.println("module load python/2-anaconda");
            qsubStream.println("module load samtools/latest");
            
            // construct the merged bams
            for (String sampleName : sampleFileNames){
                String sample = sampleName.substring(0, 6);
                // concatenat all the alignments for each sample ID
                File mergeFile = new File(mergedDir,sampleName);
                qsubStream.printf("samtools merge -@ %d - ",cores, mergeFile.getPath());
                for (String filter : filterDirs){
                    qsubStream.printf("%s/%s",filter, sampleName);
                }
                String mergedSam = String.format("%s/%s.sam",mergedDir,sample);
                String dupRemovedSam = String.format("%s/%s.sam",dupRemoveDir,sample);
                qsubStream.printf("|samtools view -h - > %s \n", mergedSam);
                qsubStream.printf("python /net/waterston/vol9/SingleCell/scripts/rm_dup_barcode_UMI.py %s %s 1\n",mergedSam,dupRemovedSam);
            }
            
        }
        else if (program.equals("SplitIntoCells")){
            inputs.get("SplitSubmitted").setValue(new Date());  
            inputs.get("SplitCompleted").setValue(null);
            String barcodeFile = inputs.get("rtBarcodeFile").getValueAsString();
            
            File samSplitted = new File(sampleDir,"sam_splitted");
            pb = new ProcessBuilder("mkdir","-p",samSplitted.getPath());
            p = pb.start();
            p.waitFor();    
            
            int cutoff = Integer.valueOf(inputs.get("Cutoff").getValueAsString());
            
            qsubStream.println("module load python/2-anaconda");     
            
            File[] files = mergedDir.listFiles();
            for (File file : files){
                if (file.getName().endsWith("sam")){
                    qsubStream.printf("python /net/waterston/vol9/SingleCell/scripts/sam_split.py %s %s %s %d \n",file.getPath(),barcodeFile,samSplitted.getPath(),cutoff);
                }
            }
            qsubStream.printf("cat %s/*sample_list.txt > %s/All_samples.txt \n" ,samSplitted.getPath(),samSplitted.getPath());
            qsubStream.printf("cp %s/All_samples.txt %s/barcode_sample.txt \n",samSplitted.getPath(),sampleDir);
            File reportDir = new File(new File(sampleDir,"report"),"barcode_read_distribution");
            qsubStream.printf("rm -rf %s\n",reportDir.getPath());
            qsubStream.printf("mkdir -p %s \n",reportDir.getPath());
            qsubStream.printf("mv %s/*.txt %s \n", samSplitted.getPath(),reportDir.getPath());
            qsubStream.printf("mv %s/*.png %s \n", samSplitted.getPath(),reportDir.getPath());
        }
        else if (program.equals("GeneCounts")){
            inputs.get("GeneCountSubmitted").setValue(new Date());  
            inputs.get("GeneCountCompleted").setValue(null);   
            AlignReference alignRef = (AlignReference)inputs.get("Reference");
            File samSplitted = new File(sampleDir,"sam_splitted");
            File sampleIDFile = new File(sampleDir,"barcode_sample.txt");
            
            qsubStream.println("module load python/2-anaconda");
            qsubStream.printf("python /net/waterston/vol9/SingleCell/scripts/sciRNASeq_count_cele_htseq.py %s %s %s %d \n"
                    ,alignRef.getHTSeqGFF(),samSplitted.getPath(),sampleIDFile.getPath(),cores);
            
            File reportDir = new File(new File(sampleDir,"report"),"gene_count");
            qsubStream.printf("mkdir -p %s\n",reportDir.getPath());
            qsubStream.printf("cat %s/*.count > %s/count.MM\n", samSplitted.getPath(),reportDir.getPath());
            qsubStream.printf("rm -f %s/*.count\n", samSplitted.getPath());
            qsubStream.printf("cat %s/*.report > %s/report.MM\n", samSplitted.getPath(),reportDir.getPath());
            qsubStream.printf("rm -f %s/*.report\n", samSplitted.getPath());
            qsubStream.printf("mv %s/*_annotate.txt %s\n",samSplitted.getPath(),reportDir.getPath() );
        }
        ArrayList<String> args = new ArrayList<>();
        args.add(program);
        args.add(sampleID);
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.sci.SampleID", args);          
        gs.run();
    }
    static public void main(String[] args)throws Exception{
        if (args[0].equals("DupRemove")){
            PreparedStatement state = MySql.getMySql().getStatement("update sciSample set DupRemovedCompleted = ? where SampleID = ?");
            state.setTimestamp(1, new Timestamp(new java.util.Date().getTime()));
            state.setString(2, args[1]);
            state.execute();   
        }
        else if (args[0].equals("SplitIntoCells")){
            PreparedStatement state = MySql.getMySql().getStatement("update sciSample set SplitCompleted = ? where SampleID = ?");
            state.setTimestamp(1, new Timestamp(new java.util.Date().getTime()));
            state.setString(2, args[1]);
            state.execute();   
        }    
        else if (args[0].equals("GeneCounts")){
            PreparedStatement state = MySql.getMySql().getStatement("update sciSample set GeneCountCompleted = ? where SampleID = ?");
            state.setTimestamp(1, new Timestamp(new java.util.Date().getTime()));
            state.setString(2, args[1]);
            state.execute();   
        }         
    }    
}
