/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.rescue;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.models.RescueModel;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class Plate extends TextCell {
    public Plate(){
        this("");
    }
    public Plate(String id){
        super(id);
        inputs.put("BombID",null);
    }
    @Override
    public void stateChanged(ChangeEvent ce) {
        String current = this.getValueAsString();
        if (!current.equals("")) return;
        // get the transcript
        CellBase base = inputs.get("BombID");
        String bombID = base.getValueAsString();
        
        // get the next design value
        RescueModel rescueModel = (RescueModel)this.getModel();
        int n = 0;
        try {
            n = rescueModel.nextPlate(bombID,this.getRow());
        }catch(Exception exc){exc.printStackTrace();}
        
        this.setValue(Integer.toString(n));
        this.unlock();
    }      
}
