/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.report;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.rhwlab.db.MySql;
import org.rhwlab.report.config.Report;
import org.rhwlab.report.config.Row;

/**
 *
 * @author gevirl
 */
public class ReportPanel extends JPanel {
    public ReportPanel(){
        super();  
    }
    public void setConfig(Report config)throws Exception{
        DefaultTableModel model = new DefaultTableModel();
        JTable table = new JTable(model);
        JScrollPane scrollPane = new JScrollPane(table);
        this.add(scrollPane); 
        
        model.addColumn(config.getLabel());
        ArrayList<String> headings = config.getHeadings();
        for (String heading : headings){
            model.addColumn(heading);
        }
        int n =config.getRowCount();
        for (int i=0 ; i<n ; ++i){
            Vector rowData = new Vector();
            Row row = config.getRow(i);
            rowData.add(row.getLabel());
            for (int j=0 ; j<headings.size() ; ++j){
                String sql = row.getSQL(headings.get(j));
                ResultSet rs = MySql.getMySql().execute(sql);
                if (rs.next()){
                    int count = rs.getInt("Count");
                    rowData.add(new Integer(count));
                }
            }
            model.addRow(rowData);
        }        
    }
}
