/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.proteinprimer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.db.beans.ChromosomeRegion;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.Highlight;
import org.rhwlab.spreadsheet.Highlightable;

/**
 *
 * @author gevirl
 */
public class UpRegion extends TextCell implements Highlightable  {
    public UpRegion(){
        this("");
    }
    public UpRegion(String val){
        super(val);
        inputs.put("Chromosome",null);
        inputs.put("GeneEnd", null);
        inputs.put("RPrimer", null);
        inputs.put("HigherLength",null);
        highLights = new ArrayList<>();        
    }
    public void stateChanged(ChangeEvent event){
        String sizeStr = inputs.get("HigherLength").getValueAsString();
        if (sizeStr.equals("")) return;
        int size = Integer.valueOf(sizeStr);
        
        // get all my inputs
        CellBase chromo = inputs.get("Chromosome");
        CellBase geneEnd = inputs.get("GeneEnd");
        int end = Integer.valueOf(geneEnd.getValueAsString());
        
        ChromosomeRegion region = new ChromosomeRegion(chromo.getValueAsString(),end+1,end+size+1);
        String dnaSeq = region.getDNASequence();
        
        
        highLights.clear();
        index = -1;
        String primer = inputs.get("RPrimer").getValueAsString();
        primer = complement(primer);
        if (!primer.equals("")){
            // try to find the primer in the dna sequence
            index = dnaSeq.lastIndexOf(primer);
            if (index >= 0) {
                Highlight highLight = new Highlight(index,index+primer.length(),new Color((float)0.0,(float)0.0,(float)1.0,(float)0.5));
                highLights.add(highLight);
            }
        }        
        this.setValue(dnaSeq);
    }
    static public String complement(String dna){
        StringBuilder builder = new StringBuilder();
        char[] chars = dna.toCharArray();
        for (int i=chars.length-1 ; i>=0 ; --i){
            char c = chars[i];
            if (c == 'c'){
                builder.append("g");
            } else if (c == 'g'){
                builder.append('c');
            } else if (c == 'a'){
                builder.append('t');
            } else if (c == 't'){
                builder.append('a');
            } else {
                builder.append('n');
            }
        }
        return builder.toString();
    }
    @Override
    public List<Highlight> getHighlights() {
        return highLights;
    }
    public int getIndex(){
        return index;
    }
    int index=-1;
    ArrayList<Highlight> highLights;    
}
