/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.proteinprimer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.db.beans.ChromosomeRegion;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.Highlight;
import org.rhwlab.spreadsheet.Highlightable;

/**
 *
 * @author gevirl
 */
public class DownRegion extends TextCell implements Highlightable {
    public DownRegion(){
        this("");
    }
    public DownRegion(String val){
        super(val);
        inputs.put("Chromosome",null);
        inputs.put("GeneStart", null);
        inputs.put("LPrimer", null);
        inputs.put("LowerLength",null);
        highLights = new ArrayList<>();
    }
    public void stateChanged(ChangeEvent event){
        String sizeStr = inputs.get("LowerLength").getValueAsString();
        if (sizeStr.equals("")) return;
        int size = Integer.valueOf(sizeStr);
        
        CellBase chromo = inputs.get("Chromosome");
        CellBase geneStart = inputs.get("GeneStart");
        int start = Integer.valueOf(geneStart.getValueAsString());
        
        ChromosomeRegion region = new ChromosomeRegion(chromo.getValueAsString(),start-size,start-1);
        String dnaSeq = region.getDNASequence();
        
        highLights.clear();
        String primer = inputs.get("LPrimer").getValueAsString();
        index = -1;
        if (!primer.equals("")){
            // try to find the primer in the dna sequence
            index = dnaSeq.indexOf(primer);
            if (index >= 0) {
                Highlight highLight = new Highlight(index,index+primer.length(),new Color((float)0.0,(float)0.0,(float)1.0,(float)0.5));
                highLights.add(highLight);
            }
        }
        this.setValue(dnaSeq);
    }

    @Override
    public List<Highlight> getHighlights() {
        return highLights;
    }
    public int getIndex(){
        return index;
    }
    int index=-1;
    ArrayList<Highlight> highLights;
}
