/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.primer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.Highlight;
import org.rhwlab.spreadsheet.Highlightable;

/**
 *
 * @author gevirl
 */
public class PlasmidSeq extends TextCell implements Highlightable {
    public PlasmidSeq(){
        this("");
    }
    public PlasmidSeq(String value){
        super(value);
        this.inputs.put("LSite",null);
        this.inputs.put("RSite",null); 
        this.inputs.put("LPrimer",null);
        this.inputs.put("RPrimer",null); 
        this.inputs.put("DNA",null);
    }

    @Override
    public boolean validate(String newValue) {
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        // get all my inputs
        RestrictionEnzyme leftSite = (RestrictionEnzyme)inputs.get("LSite");
        RestrictionEnzyme rightSite = (RestrictionEnzyme)inputs.get("RSite");
        CellBase leftPrimer = inputs.get("LPrimer");
        CellBase rightPrimer = inputs.get("RPrimer"); 
        DNA seq = (DNA)inputs.get("DNA"); 
        
        if (leftSite.getValueAsString().equals("")) return;
        if (rightSite.getValueAsString().equals("")) return;
        if (leftPrimer.getValueAsString().equals("")) return;
        if (rightPrimer.getValueAsString().equals("")) return;
        if (seq.getValueAsString().equals("")) return;
        
        
        StringBuilder builder = new StringBuilder();
        builder.append("tttt");
        builder.append(leftSite.getSequence());
        int shift = 4 + leftSite.getSequence().length();
        addHightlights(seq.getTrimmedDNA(),shift);
        builder.append(seq.getTrimmedDNA());
        ArrayList<Highlight> dnaHighs = seq.getHighlights();
        Highlight leftHigh = seq.getLeftHighlight();
        if (leftHigh!=null){
            for (Highlight high : dnaHighs){
                Highlight shifted = new Highlight(high.getStart(),high.getEnd(),high.getColor());
                shifted.shift(shift);
                shifted.shift(-leftHigh.getStart());
                highs.add(shifted);
            }
        }
        builder.append(rightSite.getSequence());
        builder.append("aaaa");
        
        this.setValue(builder.toString());
    }
    private void addHightlights(String clean,int shift){
        // highlight any areas that match the restriction enzymes
        RestrictionEnzyme leftSite = (RestrictionEnzyme)inputs.get("LSite");
        RestrictionEnzyme rightSite = (RestrictionEnzyme)inputs.get("RSite");
        highs = new ArrayList<Highlight>();
        String lsiteName = leftSite.getValueAsString();
        sitesPicked = false;
        usable = true;
        Color lcolor = new Color((float)1.0,(float)1.0,(float)0.0,(float)0.5);
        Color rcolor = new Color((float)1.0,(float)0.0,(float)1.0,(float)0.5);
        if (!lsiteName.equals("")){
            String enzymeSeq = leftSite.getSequence().toLowerCase();
            if (!enzymeSeq.equals("")){
                ArrayList<Highlight> hList = highlight(enzymeSeq,clean,lcolor);
                if (hList.size()>0)usable = false;
                for (Highlight h : hList){
                    h.shift(shift);
                }
                highs.addAll(hList);
            }
        }
        String rsiteName = rightSite.getValueAsString();
        if (!rsiteName.equals("")){
            String enzymeSeq = rightSite.getSequence().toLowerCase();
            if (!enzymeSeq.equals("")){
                ArrayList<Highlight> hList = highlight(enzymeSeq,clean,rcolor);
                if (hList.size()>0)usable = false;
                for (Highlight h : hList){
                    h.shift(shift);
                }                
                highs.addAll(hList);
            }
        } 
        sitesPicked = !rsiteName.equals("") && !lsiteName.equals("");
             
    }
    private ArrayList<Highlight> highlight(String toMatch,String seq,Color color){
        ArrayList<Highlight> ret = new ArrayList<Highlight>();
        Pattern pattern = Pattern.compile(toMatch);
        Matcher matcher = pattern.matcher(seq);
        while (matcher.find()){
            int start = matcher.start();
            int end = matcher.end();
            Highlight h = new Highlight(start,end,color);
            ret.add(h);
        }
        return ret;
    }
    public boolean isUsable(){
        if (!sitesPicked) return false;

        return usable;
    }    
    @Override
    public ArrayList<Highlight> getHighlights() {
        return highs;
    }
    static public String flip(String s){
        StringBuilder builder = new StringBuilder();
        char[] chars = s.toCharArray();
        for (int i=chars.length-1 ; i>=0 ; --i){
         builder.append(chars[i]);
        }
        return builder.toString();
    }
//    ArrayList<Highlight> shiftedHighs;
    boolean sitesPicked;
    boolean usable;
    ArrayList<Highlight> highs;    
}
