/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.primer;

import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.Highlight;
import org.rhwlab.spreadsheet.Highlightable;

/**
 *
 * @author gevirl
 */
public class DNA extends TextCell implements Highlightable {
    public DNA(){
        this("");
    }
    public DNA(String value){
        super(value);
        this.inputs.put("Left Location",null);
        this.inputs.put("Right Location",null);
        this.inputs.put("Chromosome",null);

        this.inputs.put("LPrimer",null);
        this.inputs.put("RPrimer",null);
        this.inputs.put("Gene", null);
    }    
    public boolean validate(String newValue)  {
        return true;
    }
    public boolean setValue(Object obj){
        return this.setValue(obj, true);
    }
    public boolean setValue(Object obj,boolean notify){
        addHightlights((String)obj);        
        return super.setValue(obj, notify);
    }
    
    static public String complement(String dna){
        StringBuilder builder = new StringBuilder();
        char[] chars = dna.toCharArray();
        for (int i=chars.length-1 ; i>=0 ; --i){
            char c = chars[i];
            if (c == 'c'){
                builder.append("g");
            } else if (c == 'g'){
                builder.append('c');
            } else if (c == 'a'){
                builder.append('t');
            } else if (c == 't'){
                builder.append('a');
            } else {
                builder.append('n');
            }
        }
        return builder.toString();
    }
    public void stateChanged(ChangeEvent event){
        // get all my inputs
        CellBase chromo = inputs.get("Chromosome");
        CellBase left = inputs.get("Left Location");
        CellBase right = inputs.get("Right Location");
        if (chromo.getValueAsString().equals("")) return;
        if (left.getValueAsString().equals("")) return;
        if (right.getValueAsString().equals("")) return;
        
        leftPos = Integer.parseInt(left.getValueAsString());
        if (leftPos==0) return;
        rightPos = Integer.parseInt(right.getValueAsString());
        if (rightPos == 0) return;
        
        String start = null;
        String end = null;
        if (leftPos <= rightPos){
            start = left.getValueAsString();
            end = right.getValueAsString();
        } else {
            start = right.getValueAsString();
            end = left.getValueAsString();
        }
        
        // build the url to fetch the dna sequence
        String urlString = String.format("http://genome.cse.ucsc.edu/cgi-bin/das/ce10/dna?segment=%s:%s,%s",
                chromo.getValueAsString(),start,end);
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = null;
        try {
            doc = saxBuilder.build(new URL(urlString)); 
        } catch (Exception exc){
            this.setValue("");
            return;
        }
        if (doc == null) {
            this.setValue("");
            return;
        }
        Element root = doc.getRootElement();
        Element sequence = root.getChild("SEQUENCE");
        Element dna = sequence.getChild("DNA");
        String dnaString = dna.getTextNormalize();
        String clean = dnaString.replace(" ","");
        if (leftPos > rightPos)
            clean = complement(clean);

        this.setValue(clean);
    }
    private void addHightlights(String clean){

        Color leftColor = new Color((float)0.0,(float)0.0,(float)1.0,(float)0.5);
        Color rightColor = new Color((float)0.0,(float)1.0,(float)0.0,(float)0.5);

        
        // highlight the primers
        Primer primer = (Primer)inputs.get("LPrimer");
        String leftPrimer = primer.getValueAsString().toLowerCase();
        ArrayList<Align> aligns = align(leftPrimer,0,clean);
//        ArrayList<Highlight> hList = highlight(leftPrimer,clean,Color.LIGHT_GRAY);
        if (!aligns.isEmpty()){
            Align align = aligns.get(0);
            leftHighlight = new Highlight(align.pos,align.pos+leftPrimer.length(),leftColor);
        }
        primer = (Primer)inputs.get("RPrimer");
        String rightPrimer = complement(primer.getValueAsString().toLowerCase());
        aligns = align(rightPrimer,0,clean);
//        ArrayList<Highlight>hList = highlight(complement(primer.getValueAsString()).toLowerCase(),clean,rightColor);
        if (!aligns.isEmpty()){
            Align align = aligns.get(0);
            rightHighlight = new Highlight(align.pos,align.pos+rightPrimer.length(),rightColor);
        }      
    }

    // find all places where the given read aligns with the sequence
    // allow nMiss mismatches
    public ArrayList<Align> align(String read,int readPos,String seq){
        ArrayList<Align> ret = null;
        if (read.equals("")) return new ArrayList<Align>();
        char c = read.charAt(readPos);
        if (readPos == read.length()-1){
            ret = new ArrayList<Align>();
            for (int i=read.length()-1 ; i<seq.length();++i){
                char s = seq.charAt(i);
                if (c == s){
                    ret.add(new Align(i,0));
                } else {
                    ret.add(new Align(i,1));
                }
            }
            
        }else {
            ret = align(read,readPos+1,seq);
            for (int i=ret.size()-1 ; i>=0 ; --i){
                Align align = ret.get(i);
                --align.pos;
                char s = seq.charAt(align.pos);
                if (c != s){
                    if (align.miss == nMiss){
                        ret.remove(i);
                    }else {
                        ++align.miss;
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public ArrayList<Highlight> getHighlights() {
        ArrayList<Highlight> ret = new ArrayList<Highlight>();
        if (this.leftHighlight!=null) ret.add(this.leftHighlight);
        if (this.rightHighlight!=null)ret.add(this.rightHighlight);
        return ret;
    }
    public class Align {
        public Align(int pos,int miss){
            this.pos = pos;
            this.miss = miss;
        }
        int pos;
        int miss;
    }
    public int getLeftPrimerEdge(){
        
        CellBase chromo = inputs.get("Chromosome");
        CellBase left = inputs.get("Left Location");
        CellBase right = inputs.get("Right Location");
        leftPos = Integer.parseInt(left.getValueAsString());
        rightPos = Integer.parseInt(right.getValueAsString());   
        if (this.leftHighlight == null) return -1;
        int start = leftHighlight.getStart();
        if (leftPos > rightPos){
            return leftPos - start;
        }else {
            return leftPos + start;
        }
    }
    public int getRightPrimerEdge(){
        
        CellBase left = inputs.get("Left Location");
        CellBase right = inputs.get("Right Location");
        leftPos = Integer.parseInt(left.getValueAsString());
        rightPos = Integer.parseInt(right.getValueAsString());   
        if (this.rightHighlight == null) return -1;
        int del = this.getValueAsString().length()-rightHighlight.getEnd();
        if (leftPos > rightPos){
            return rightPos + del;
        }else {
            return rightPos -del;
        }
    } 
    public String getTrimmedDNA(){
        if (leftHighlight==null || rightHighlight==null) return "";
        
        String dna = this.getValueAsString();
        return dna.substring(leftHighlight.getStart(), rightHighlight.getEnd());
    }

    public Highlight getLeftHighlight(){
        return this.leftHighlight;
    }
    int leftPos;
    int rightPos;

    Highlight leftHighlight;
    Highlight rightHighlight;
    static int nMiss = 1;
}
