/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.pcr;

import java.sql.ResultSet;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class PCRSummary extends TextCell {
    
    @Override
    public boolean setValue(Object o){
        return this.setValue(o,true);
    }
    
    @Override
    public boolean setValue(Object o,boolean b){
        
        setConstructID((String)o);
        return super.setValue(o, b);
    }
    
    public void setConstructID(String constructID) {
        
        totalScreened = 0;
        expressing = 0;
        nonExpressing = 0;
        positive = 0;
        negative = 0;
        String sql = String.format("Select * from Screening where ConstructID = \'%s\'",constructID);
        try {
            ResultSet rs = MySql.getMySql().execute(sql);
            while (rs.next()){
                ++totalScreened;
                if (rs.getBoolean("Expressing")){
                    ++expressing;
                }else {
                    ++nonExpressing;
                }
                gene = rs.getString("Gene");
                wbGene = rs.getString("WBGene");
                String rescueID = rs.getString("RescueID");
                String sql1 = String.format("Select * from SingleWormPCR where RescueID=\'%s\' and Target= \'GFP\'",rescueID);
                ResultSet rs1 = MySql.getMySql().execute(sql1);
                while(rs1.next()){
                    String result = rs1.getString("Result");
                    if (result.equals("Positive")) ++positive;
                    if (result.equals("Negative")) ++negative;
                }
                
            }
            sql = String.format("select * from GeneStageDCPM where WBGene=\'%s\' order by DCPM desc limit 1", wbGene);
            rs = MySql.getMySql().execute(sql);
            if (rs.next()){
                this.stage = rs.getInt("Stage");
                this.dcpm = rs.getDouble("DCPM");
            }
        } catch(Exception exc){
            exc.printStackTrace();
        }
    }
    public int getScreenedTotal(){
        return this.totalScreened;
    }
    public int getExpressing(){
        return this.expressing;
    }
    public int getNonExpressing(){
        return this.nonExpressing;
    }
    public String getGene(){
        return this.gene;
    }
    public String getWBGene(){
        return this.wbGene;
    }
    public int getPositivePCR(){
        return this.positive;
    }
    public int getNegativePCR(){
        return this.negative;
    }
    public int getStage(){
        return stage;
    }
    public double getDCPM(){
        return this.dcpm;
    }
    int totalScreened;
    int expressing;
    int nonExpressing;
    int positive;
    int negative;
    String gene;
    String wbGene;
    int stage;
    double dcpm;
}
