/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.path;

import java.awt.BorderLayout;
import static java.awt.image.ImageObserver.WIDTH;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;

/**
 *
 * @author gevirl
 */
public class StatusSummaryPanel extends JPanel implements ListSelectionListener {
    public StatusSummaryPanel(String path,String project,DefaultTableModel model){
        jtable = new JTable(model);


        jtable.getSelectionModel().addListSelectionListener(this);
        jtable.setAutoCreateRowSorter(true);
        TableRowSorter sorter = (TableRowSorter)jtable.getRowSorter();
        int n = PathStatusFrame.N;
        for (int i=n+1 ; i<jtable.getColumnCount() ; ++i){
           sorter.setComparator(i, new PathStatus("","")); 
        }        
//               jtable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        JScrollPane scroll = new JScrollPane(jtable);
        this.setLayout(new BorderLayout());
        String title = String.format("Project: %s -- Path: %s",project,path);
        this.setBorder(new TitledBorder(title));
        this.add(scroll,BorderLayout.CENTER);

        JPanel countPanel = new JPanel();
        countPanel.setLayout(new BoxLayout(countPanel,BoxLayout.X_AXIS));
        totalCount = new JLabel(Integer.toString(model.getRowCount()));
        countPanel.add(new JLabel("Total: "));
        countPanel.add(totalCount);
        countPanel.add(Box.createHorizontalStrut(20));
        countPanel.add(new JLabel("Selected: "));
        selectedCount = new JLabel("0");
        countPanel.add(selectedCount);
        this.add(countPanel,BorderLayout.SOUTH); 
        
    }
    

    @Override
    public void valueChanged(ListSelectionEvent e) {
        selectedCount.setText(Integer.toString(jtable.getSelectedRowCount()));
    }
    public JTable getTable(){
        return jtable;
    }
    JTable jtable;
    JLabel totalCount;
    JLabel selectedCount;    
}
