/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.path;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */

// construct a status table for a given path
public class PathStatusTable {
    public PathStatusTable(String pathName,String startTable,String startColumn) throws Exception{
        this.pathName = pathName;
        path = new TreeMap<>();
        if(columns == null){
            columns = new ArrayList<>();
            columns.add("Root");
            columns.add("Project");
            columns.add("Order");
            columns.add("Table");
            columns.add("Key");
            columns.add("Status");
            columns.add("Reason");            
        }
        
        // get the path description from the database
        String sql = String.format("Select * from LMSLinkage where PathName=\'%s\'",pathName);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            PathLinkage link = new PathLinkage(rs.getString("SourceColumn"),rs.getString("DestTable"),rs.getString("DestColumn"),rs.getString("FilterSQL"));
            path.put(rs.getString("SourceTable"),link);
        }
        
        // set up the display table
        model = new DefaultTableModel();
        for (String column : columns){
            model.addColumn(column);
        }
        
        // get all the root keys for this path
        PathLinkage firstLink = path.get(startTable);
        sql = String.format("Select %s,%s from %s",startColumn,firstLink.sourceColumn,startTable);
        rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            rootKey = rs.getString(startColumn);

            String linkValue = rs.getString(firstLink.sourceColumn);
            addStatus(rootKey,startTable,1,linkValue);
            tracing = false;
        }
    }
    private void addStatus(String key,String table,int level,String linkValue)throws Exception{
        String sql = String.format("Select * from LMSTracking where ID = \'%s\' and DBTable = \'%s\'",key,table);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String project = rs.getString("Project");
            String status = rs.getString("Status");
            String reason = rs.getString("Reason");
            Object[] row = new Object[7];
            row[0] = rootKey;
            row[1] = project;
            row[2] = level;
            row[3] = table;
            row[4] = key;
            row[5] = status;
            row[6] = reason;
            if (tracing){
                System.out.printf("%s %s %s %s\n",table,key,status,reason);
            }
            model.addRow(row);
        }
        // find the next table in the path
        PathLinkage link = path.get(table);
        if (link != null){
            if (link.dest==null) return;
            // find the primary key of the dest table
            sql = String.format("select column_name from information_schema.columns where table_name=\'%s\' and column_key=\'PRI\'", link.dest);
            rs = MySql.getMySql().execute(sql);
            rs.next();
            String destkeyColumn = rs.getString("column_name");
            
            PathLinkage nextLink = path.get(link.dest);
            if (nextLink.filter!= null){
                sql = String.format("Select %s,%s from %s where %s = \'%s\' and %s",destkeyColumn,nextLink.sourceColumn,link.dest,link.destColumn,linkValue,nextLink.filter);
            }else {
                sql = String.format("Select %s,%s from %s where %s = \'%s\'",destkeyColumn,nextLink.sourceColumn,link.dest,link.destColumn,linkValue);
            }

            rs = MySql.getMySql().execute(sql);
            while (rs.next()){
                String nextKey = rs.getString(destkeyColumn);
                String nextValue = rs.getString(nextLink.sourceColumn);
                if (tracing) System.out.printf("%s %s\n",nextKey,nextValue);
                addStatus(nextKey,link.dest,level+1,nextValue);
            }
        }
        
    }
    public void saveToDB()throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("Insert into LMSSummary (Path,Project,RootKey,DBTable,PathOrder,DataKey,Status,Reason) values (?,?,?,?,?,?,?,?)");
        int R = model.getRowCount();
        for (int r=0 ; r<R ; ++r){
            state.setString(1,pathName);
            state.setString(2, (String)model.getValueAt(r, columns.indexOf("Project")));
            state.setString(3, (String)model.getValueAt(r, columns.indexOf("Root")));
            state.setString(4, (String)model.getValueAt(r, columns.indexOf("Table")));
            state.setInt(5, (Integer)model.getValueAt(r, columns.indexOf("Order")));
            state.setString(6, (String)model.getValueAt(r, columns.indexOf("Key")));
            state.setString(7, (String)model.getValueAt(r, columns.indexOf("Status")));
            state.setString(8, (String)model.getValueAt(r, columns.indexOf("Reason")));
            state.execute();
        }
    }
    public DefaultTableModel getModel(){
        return this.model;
    }
    public static void rebuildAll()throws Exception {
        String sql = "delete from LMSSummary";
        MySql.getMySql().execute(sql);
        
        // get all the paths
        sql = "Select * from LMSPath";
        ResultSet rs = MySql.getMySql().execute(sql);
        while(rs.next()){
            PathStatusTable table = new PathStatusTable(rs.getString("Name"),rs.getString("StartTable"),rs.getString("StartColumn"));
            table.saveToDB();
        }
      
    }
    public static void rebuildPath(String path)throws Exception{
        String sql = String.format("delete from LMSSummary where Path=\'%s\'",path);
        MySql.getMySql().execute(sql); 
        sql = String.format("Select * from LMSPath where Name=\'%s\'",path);
        ResultSet rs = MySql.getMySql().execute(sql); 
        rs.next();
        PathStatusTable table = new PathStatusTable(rs.getString("Name"),rs.getString("StartTable"),rs.getString("StartColumn"));
        table.saveToDB();        
    }
    static public void main(String[] args)throws Exception{
        rebuildPath(args[0]);
    }
    boolean tracing=false;
    String rootKey;
    String pathName;
    TreeMap<String,PathLinkage> path;
    DefaultTableModel model;
    static ArrayList<String> columns;
}

class PathLinkage {
    public PathLinkage(String sourceColumn,String dest,String destColumn,String filter){
        this.sourceColumn = sourceColumn;
        this.dest = dest;
        this.destColumn = destColumn;
        this.filter = filter;
    }
    String sourceColumn;
    String dest;  // destination table
    String destColumn;
    String filter;
    
}
