/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.path;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/**
 *
 * @author gevirl
 */
public class PathStatus implements Comparator {
    public PathStatus(String status,String table){
        this.table=table;
        this.status = status;
        this.reasons = new ArrayList<>();
    }
    public void addReason(String reason){
        reasons.add(reason);
    }
    public String toString(){
        if (reasons.isEmpty()){
            return "";
        }
        return String.format("%s(%d)",table,reasons.size());
    }
    public List getReasons(){
        return reasons;
    }
    public String getTable(){
        return table;
    }
    public String getStatus(){
        return status;
    }

    @Override
    public int compare(Object o1, Object o2) {
        PathStatus p1 = (PathStatus)o1;
        PathStatus p2 = (PathStatus)o2;
        int ret = p1.table.compareTo(p2.table);
        if (ret == 0){
            ret = p1.reasons.size() - p2.reasons.size();
        }
        return ret;
    }
/*        
        int n1 = ((PathStatus)o1).reasons.size();
        int n2 = ((PathStatus)o2).reasons.size();
        return n1-n2;
    } 
    * */
    List<String> reasons;
    String table;
    String status;
}
