/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.path;

import java.sql.ResultSet;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class DisplayPathDialog extends JDialog {
    public DisplayPathDialog(){
        content = new JPanel();
        content.setLayout(new BoxLayout(content,BoxLayout.X_AXIS));
    }
    public void DisplayPaths(String[] paths)throws Exception{
        content.removeAll();
        for (String path : paths){
            content.add(pathDisplayList(path));
        }
        JScrollPane scroll = new JScrollPane(content);
        this.setContentPane(scroll);
        this.validate();
        this.repaint();
    }
    private JPanel pathDisplayList(String path)throws Exception{
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret,BoxLayout.Y_AXIS));
        ret.add(new JLabel(path));
        JList list = new JList(fetchPathTables(path));
        JScrollPane scroll = new JScrollPane(list);
        ret.add(scroll);
        return ret;
    }
    private String[] fetchPathTables(String path)throws Exception{
        String sql = String.format("select * from LMSPath where Name=\'%s\'",path);
        ResultSet rs = MySql.getMySql().execute(sql);
        rs.next();
        String table = rs.getString("StartTable");
        String filter = "";
        ArrayList<String> list = new ArrayList<>();
        while (table != null){
            sql = String.format("select * from LMSLinkage where SourceTable=\'%s\' and PathName=\'%s\'",table,path);
            rs = MySql.getMySql().execute(sql);
            rs.next();
            filter = rs.getString("FilterSQL");
            if (filter == null) filter = "";            
            
            if (!filter.equals("")){
                list.add(String.format("%s(%s)",table,filter));   
            } else {
                list.add(String.format("%s",table));
            }
            

            table = rs.getString("DestTable");
        }
        return (String[])list.toArray(new String[0]);
    }
    JPanel content;
}
