/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.onset;

import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.beans.ExpOnsetsEmbryo;
import org.rhwlab.beans.SulstonEmbryo;
import org.rhwlab.db.MySql;
import org.rhwlab.expression.ExpressionOnset;

/**
 *
 * @author gevirl
 */
public class Onsets extends TextCell {
    public Onsets()throws Exception {
        super("");
        if (sulstonEmbryo==null){
            sulstonEmbryo = new SulstonEmbryo(MySql.getMySql());
        }
    }
    public ExpOnsetsEmbryo getEmbryo()throws Exception{
        if (embryo == null){
            if (map != null){
                ExpressionOnset first = map.values().iterator().next();
                String seriesID = this.getValueAsString();
                String expType = first.getType();
                embryo = new ExpOnsetsEmbryo(MySql.getMySql(),seriesID,expType,sulstonEmbryo);
            }
        }
        return embryo;
        
    }
    @Override
    public void stateChanged(ChangeEvent ce) {
        Object source = ce.getSource();
        if (source instanceof TextCell){
            String seriesID = ((TextCell)source).getValueAsString();
            try {
                map =ExpressionOnset.getOnsetsFromDB(MySql.getMySql(), seriesID);
                if (!map.isEmpty()){
                    this.setValue(seriesID);
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }  
    
    @Override
    public boolean validate(String newValue) {
        return true;
    }
    public HashMap<String, ExpressionOnset> getMap(){
        return map;
    }
    public void setMapfromEmbryo(){
        map = embryo.getAllOnsets();
    }
    public boolean updateDB() throws Exception {
        if (this.hasChanged()){
            ExpressionOnset.removeOnsetsFromDB(MySql.getMySql(), embryo.getID());
            for (ExpressionOnset on : map.values()){
                on.saveToDB(MySql.getMySql());
            }
            this.setModified(false);
            return true;
        }
        return false;
    }
    static public SulstonEmbryo sulstonEmbryo = null;
    ExpOnsetsEmbryo embryo=null;
    HashMap<String,ExpressionOnset> map=null;
}
