/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.models;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;

/**
 *
 * @author gevirl
 */
public class ImagingModel extends SpreadSheetModel{
    public int nextImageCount(String strain,int row) throws Exception {
        // get the largest id from the database
        String sql = String.format("Select max(ImagedCount) max from Imaging where StrainID=\'%s\' ",
                strain);
        ResultSet rs = MySql.getMySql().execute(sql);
        boolean b = rs.next();
        int max = rs.getInt("max");  // returns zero if no records 
        
        // also look at the ids in the spreadsheet in case there have been additions
        int strainColumn = this.getConfig().getColumn("StrainID");
        int countColumn = this.getConfig().getColumn("ImagedCount");
                
        int n = this.getRowCount();
        for (int r=0 ; r<n ; ++r){
            if (r == row) continue;
            CellBase base = (CellBase)this.getValueAt(r,strainColumn);
            
            String id = base.getValueAsString();
            if (id.equals("") || !id.equals(strain)) continue;

            
            String count = ((CellBase)this.getValueAt(r,countColumn)).getValueAsString();
            if (count.equals(""))continue;            
            int countValue = Integer.valueOf(count);
            if (max < countValue) max = countValue;
        }
        return max+1;        
    }     
    public void archive(int[] rows) throws Exception   {
        PreparedStatement state = MySql.getMySql().getStatement("Update Imaging set Archived = 1 where ImagingID = ?");
        int col = this.findColumn("RescueID");
        for (int row : rows){
//            RescueID rescueID  = (RescueID)this.getValueAt(row, col);
//            state.setString(1, rescueID.getValueAsString());
            state.execute();
        }
    }    
}
