/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.models;

import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.config.SpreadSheet;

/**
 *
 * @author gevirl
 */
public class GlycerolStockModel extends SpreadSheetModel {

    public int addEmptyRow(){
        int ret = super.addEmptyRow();
        BRCStockLocation loc = maxLocation();
        if (loc == null) return ret;
        loc.increment(9,9);
        ((CellBase)this.getValueAt(ret, b)).setValue(loc.getBox());
        ((CellBase)this.getValueAt(ret, c)).setValue(loc.getColumn());
        ((CellBase)this.getValueAt(ret, r)).setValue(loc.getRow());
        return ret;        
    }
    public void setConfig(SpreadSheet config) throws Exception {    
        super.setConfig(config);
        b = config.getColumn("Box");
        r = config.getColumn("Row");
        c = config.getColumn("Column");
    }
    public BRCStockLocation maxLocation(){
        // find the maximum location value
        int n = this.getRowCount();
        if (n==0) return null;
        
        BRCStockLocation maxloc = this.getLocation(0);
        if (n==1) return maxloc;
        
        for (int r=1 ; r<n ; ++r){
            BRCStockLocation loc = this.getLocation(r);
            if (loc != null){
                if (maxloc.compareTo(loc)==-1){
                    maxloc = loc;
                }
            }
        }
        return maxloc;
    }
    // gets the location for the given row
    // return null if no values set
    public BRCStockLocation getLocation(int row){
        String boxStr = ((CellBase)this.getValueAt(row, b)).getValueAsString();
        String rowStr = ((CellBase)this.getValueAt(row, r)).getValueAsString();
        String colStr = ((CellBase)this.getValueAt(row, c)).getValueAsString();
        
        return fromString(boxStr,rowStr,colStr);
    }
    static public BRCStockLocation fromString(String boxStr,String rowStr,String colStr){
        if (boxStr==null || rowStr==null || colStr==null){
            return new BRCStockLocation(0,' ',0);
        }
        if (boxStr.equals("")) return new BRCStockLocation(0,' ',0);
        int box;
        try {
            box = Integer.parseInt(boxStr);
        } catch(Exception exc){ return new BRCStockLocation(0,' ',0);}
        
        if (rowStr.equals("")) return new BRCStockLocation(0,' ',0);
        
        int col;
        if (colStr.equals("")) return new BRCStockLocation(0,' ',0);
        try {
            col = Integer.parseInt(colStr);
        } catch (Exception exc){return new BRCStockLocation(0,' ',0);}
        
        return new BRCStockLocation(box,rowStr.charAt(0),col);        
    }
    int b;  // box column
    int r;  // row column
    int c;  // column column
}
