/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.models;

import java.sql.ResultSet;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;

/**
 *
 * @author gevirl
 */
public class FlyRNASampleModel extends SpreadSheetModel {
    // determine the next available freezeno for the given strain
    public int nextSample(String strain,String stage,int row) throws Exception {
        // get the largest id from the database
        String sql = String.format("Select max(SampleNumber) max from FlyRNASample where StrainID=\'%s\' and Stage =\'%s\'",strain,stage);
        ResultSet rs = MySql.getMySql().execute(sql);
        boolean b = rs.next();
        int max = rs.getInt("max");  // returns zero if no records for the transcript;
        
        // also look at the transcripts in the spreadsheet in case the have been additions
        int strainColumn = this.getConfig().getColumn("StrainID");
        int stageColumn = this.getConfig().getColumn("Stage");
        int sampleNoColumn = this.getConfig().getColumn("SampleNumber");
                
        int n = this.getRowCount();
        for (int r=0 ; r<n ; ++r){
            if (r == row) continue;
            CellBase base = (CellBase)this.getValueAt(r,strainColumn);
            String cellStrain = base.getValueAsString();
            if (cellStrain.equals("") || !cellStrain.equals(strain)) continue;
            
            base = (CellBase)this.getValueAt(r,stageColumn);
            String cellStage = base.getValueAsString();
            if (cellStage.equals("") || !cellStage.equals(stage)) continue;            
            
            String cellNumber = ((CellBase)this.getValueAt(r,sampleNoColumn)).getValueAsString();
            if (cellNumber.equals(""))continue;
            int numberValue = Integer.valueOf(cellNumber);
            if (max < numberValue) max = numberValue;
        }
        return max+1;
    } 
    public int nextExperiment(String gene,String method,int row)throws Exception {
        // get the largest id from the database
        String sql = String.format(
                "Select max(DataSetNumber) max from FlyRNASample where KnockDownMethod=\'%s\' and TargetGene =\'%s\'",
                method,gene);
        ResultSet rs = MySql.getMySql().execute(sql);
        boolean b = rs.next();
        int max = rs.getInt("max");  // returns zero if no records         
        // also look at the transcripts in the spreadsheet in case the have been additions
        int methodColumn = this.getConfig().getColumn("KnockDownMethod");
        int geneColumn = this.getConfig().getColumn("TargetGene");
        int expNoColumn = this.getConfig().getColumn("ExpNo");
                
        int n = this.getRowCount();
        for (int r=0 ; r<n ; ++r){
            if (r == row) continue;
            CellBase base = (CellBase)this.getValueAt(r,methodColumn);
            String cellMethod = base.getValueAsString();
            if (cellMethod.equals("") || !cellMethod.equals(method)) continue;
            
            base = (CellBase)this.getValueAt(r,geneColumn);
            String cellGene = base.getValueAsString();
            if (cellGene.equals("") || !cellGene.equals(gene)) continue;            
            
            String cellNumber = ((CellBase)this.getValueAt(r,expNoColumn)).getValueAsString();
            if (cellNumber.equals(""))continue;
            int numberValue = Integer.valueOf(cellNumber);
            if (max < numberValue) max = numberValue;
        }        
        return max+1;
    }
    public int nextDataSet(String strainID,int row)throws Exception {
        // get the largest id from the database
        String sql = String.format(
                "Select max(DataSetNumber) max from FlyRNASample where StrainID=\'%s\' ",strainID);
        ResultSet rs = MySql.getMySql().execute(sql);
        boolean b = rs.next();
        int max = rs.getInt("max");  // returns zero if no records   
        
        // also look at the transcripts in the spreadsheet in case the have been additions
        int strainColumn = this.getConfig().getColumn("StrainID");
        int numColumn = this.getConfig().getColumn("DataSetNo");
                
        int n = this.getRowCount();
        for (int r=0 ; r<n ; ++r){
            if (r == row) continue;
            CellBase base = (CellBase)this.getValueAt(r,strainColumn);
            String cellStrain = base.getValueAsString();
            if (cellStrain.equals("") || !cellStrain.equals(strainID)) continue;
            
            String cellNumber = ((CellBase)this.getValueAt(r,numColumn)).getValueAsString();
            if (cellNumber.equals(""))continue;
            int numberValue = Integer.valueOf(cellNumber);
            if (max < numberValue) max = numberValue;
        }        
        return max+1;
    }    
}
