/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.models;

import java.sql.ResultSet;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;

/**
 *
 * @author gevirl
 */
public class BombModel extends SpreadSheetModel {
    public int nextBomb(String dnaPrep,int row) throws Exception {
        // get the largest id from the database
        String sql = String.format("Select max(BombNumber) max from Bomb where DNAPrepID=\'%s\' ",
                dnaPrep);
        ResultSet rs = MySql.getMySql().execute(sql);
        boolean b = rs.next();
        int max = rs.getInt("max");  // returns zero if no records 
        
        // also look at the ids in the spreadsheet in case there have been additions
        int idColumn = this.getConfig().getColumn("DNAPrepID");
        int bombColumn = this.getConfig().getColumn("Bomb Number");
                
        int n = this.getRowCount();
        for (int r=0 ; r<n ; ++r){
            if (r == row) continue;
            CellBase base = (CellBase)this.getValueAt(r,idColumn);
            
            String id = base.getValueAsString();
            if (id.equals("") || !id.equals(dnaPrep)) continue;

            
            String bomb = ((CellBase)this.getValueAt(r,bombColumn)).getValueAsString();
            if (bomb.equals(""))continue;            
            int bombValue = Integer.valueOf(bomb);
            if (max < bombValue) max = bombValue;
        }
        return max+1;        
    }  
    public BRCStockLocation maxPrepLocation(){
        BRCStockLocation ret = new BRCStockLocation("1A0");
        int col = this.findColumn("PrepLocation");
        int n = this.getRowCount();
        for (int r=0 ; r<n ; ++r){
            CellBase base = (CellBase)this.getValueAt(r,col);
            String locStr = base.getValueAsString();
            if (!locStr.equals("")){
                BRCStockLocation loc = new BRCStockLocation(locStr);    
                if (loc.compareTo(ret)>0){
                    ret = loc;
                }
            }
        }
        return ret;
    }
}
