/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.models;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * @author gevirl
 */
public class BRCStockLocation implements Comparable{
    public BRCStockLocation(){
        
    }
    public BRCStockLocation(String loc){
        this.parse(loc);
    }
    public BRCStockLocation(int box,char row,int column){
        this.box = box;
        this.column = column;
        this.row = row;
    }

    public void increment(int maxRows,int maxColumns){
        if (column < maxColumns) {
            ++column;
            return;
        } 
        int index = -1;
        for (int i=0 ; i<rows.length ; ++i){
            if (this.row == rows[i]){
                index = i;
                break;
            }
        }
        
        if (index==maxRows-1) {
            row = rows[0];
            column = 1;
            ++box;
            return;
        } else {
            row = rows[index+1];
            column = 1;
            return;
        }
    }

    @Override
    public int compareTo(Object t) {
        if (t== null) return 0;
        BRCStockLocation other = (BRCStockLocation)t;
        if (this.box < other.box ) return -1;
        if (this.box > other.box ) return 1;
        
        if (this.row < other.row) return -1;
        if (this.row > other.row) return 1;
 
        if (this.column < other.column ) return -1;
        if (this.column > other.column ) return 1;        
        
        return 0;
    }
    public String getBox(){
        return String.format("%d",box);
    }
    public String getColumn(){
        return String.format("%d",column);
    }
    public String getRow(){
        StringBuilder builder = new StringBuilder();
        builder.append(row);
        return builder.toString();
    }
    final public boolean parse(String in){
        Pattern p = Pattern.compile("([0-9]+)([A-Z])([0-9]+)");
        Matcher m = p.matcher(in);
        if (m.matches()){
            box = Integer.valueOf(m.group(1));
            row = m.group(2).charAt(0);
            column = Integer.valueOf(m.group(3));
            return true;
        }
        return false;
    }
    public String asString(){
        return String.format("%d%c%d", box,row,column);
    }
    public static void main(String[] args){
        BRCStockLocation location = new BRCStockLocation(args[0]);
        int asiofhd=0;
    }
    
    int box;
    char row;
    int column;
    static char[] rows = {'A','B','C','D','E','F','G','H','I','J'};
}