/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.intergenic;

import org.rhwlab.db.beans.Gene;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class IntergenicCell extends CellBase {
    public boolean setValue(Object obj,boolean notify){
        String geneName = (String)obj;
        if (this.model.isLoading()) {
            return super.setValue(obj,notify);
        }
        try {
            Gene gene = new Gene(geneName);
            Intergenic inter = new Intergenic(gene);
            return super.setValue(inter,notify);
        } catch (Exception exc){
            return false;
        }
    }

    @Override
    public boolean validate(String newValue) {
        return true;
    }

    @Override
    public String getValueAsString() {
        Object o = this.getValue();
        if (o instanceof String){
            return (String)o;
        }
        Intergenic intergenic = (Intergenic)o;
        return intergenic.getGene().getWBGene();
    }

    @Override
    public int compareTo(Object o) {
        IntergenicCell other = (IntergenicCell)o;
        return this.getValueAsString().compareToIgnoreCase(other.getValueAsString());
    }
    
}
