/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.intergenic;

import org.rhwlab.db.beans.ChromosomeRegion;
import org.rhwlab.db.beans.Gene;
import org.rhwlab.mysql.WBGeneAnnotation;

/**
 *
 * @author gevirl
 */
public class Intergenic {
    public Intergenic(Gene gene)throws Exception {
        this.gene = gene;
        String biotype = "protein_coding";
        this.lowerGene = gene.getDownGene(biotype);
        this.higherGene = gene.getUpGene(biotype);
        
        if (this.lowerGene != null){
            this.lowerRegion = new ChromosomeRegion(gene.getRegion().getChromosome(),lowerGene.getRegion().getEnd(),gene.getRegion().getStart()-1);
        }else {
            this.lowerRegion = new ChromosomeRegion(gene.getRegion().getChromosome(),1,gene.getRegion().getStart()-1);
        }
        
        if (this.higherGene != null){
            this.higherRegion = new ChromosomeRegion(gene.getRegion().getChromosome(),gene.getRegion().getEnd()+1,higherGene.getRegion().getStart());
        }else {
            this.higherRegion = new ChromosomeRegion(gene.getRegion().getChromosome(),gene.getRegion().getEnd()+1,WBGeneAnnotation.getChromosomeSize(gene.getRegion().getChromosome()));
        }
        
        geneRegion = new ChromosomeRegion(gene.getRegion().getChromosome(),gene.getRegion().getStart(),gene.getRegion().getEnd());
    }
    public Gene getGene(){
        return gene;
    }
    public WBGeneAnnotation getLowerGene(){
        return this.lowerGene;
    }
    public WBGeneAnnotation getHigherGene(){
        return this.higherGene;
    }
    public ChromosomeRegion getLowerRegion(){
        return this.lowerRegion;
    }
    public ChromosomeRegion getHigherRegion(){
        return this.higherRegion;
    }
    public ChromosomeRegion getGeneRegion(){
        return this.geneRegion;
    }
    
    Gene gene;
    WBGeneAnnotation lowerGene;
    WBGeneAnnotation higherGene;
    ChromosomeRegion lowerRegion;
    ChromosomeRegion higherRegion;
    ChromosomeRegion geneRegion;
}
