/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.BorderLayout;
import java.awt.CheckboxGroup;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.config.Column;
import org.rhwlab.spreadsheet.config.SpreadSheet;

/**
 *
 * @author gevirl
 */

// construct a where clause for a table
public class WhereClausePanel extends JPanel {
    public WhereClausePanel(){
        
//        fieldsBox.setMinimumSize(new Dimension(100,30));
        fieldsBox.setMaximumSize(new Dimension(400,30));
        //valuesBox.setMinimumSize(new Dimension(200, 30));
        valuesBox.setMaximumSize(new Dimension(400, 30));
        //relationBox.setMinimumSize(new Dimension(100,30));
        relationBox.setMaximumSize(new Dimension(100,30));
        JPanel columnPanel = new JPanel();
        columnPanel.setLayout(new BoxLayout(columnPanel,BoxLayout.Y_AXIS));
        columnPanel.add(new JLabel("Column Name"));
        columnPanel.add(fieldsBox);
        fieldsBox.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                String col = (String)fieldsBox.getSelectedItem();
                if (col != null){
                    try {
                        int c = config.getColumn(col);
                        setValuesInBox(config.getColumn(c).getDbColumn());
                    } catch (Exception exc){
                        exc.printStackTrace();
                    }
                }
            }
        });
        
        JPanel relationPanel = new JPanel();
        relationPanel.setLayout(new BoxLayout(relationPanel,BoxLayout.Y_AXIS));
        relationPanel.add(new JLabel("Relation"));
        relationPanel.add(relationBox);
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        model.addElement("=");
        model.addElement("<=");
        model.addElement("<");
        model.addElement(">=");
        model.addElement(">"); 
        model.addElement("!=");
        relationBox.setModel(model);
        
        JPanel valuesPanel = new JPanel();
        valuesPanel.setLayout(new BoxLayout(valuesPanel,BoxLayout.Y_AXIS));
        valuesPanel.add(new JLabel("Values"));
        valuesPanel.add(valuesBox);
        
        JPanel andorPanel = new JPanel();
        andorPanel.setLayout(new BoxLayout(andorPanel,BoxLayout.Y_AXIS));
        andorPanel.add(andCheck);
        andorPanel.add(orCheck);
        JButton addButton = new JButton("Add");
        addButton.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                addToCommand();
            }
        });
        andorPanel.add(addButton);
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                commandField.setText("");
            }
        });
        andorPanel.add(clearButton);
        ButtonGroup group = new ButtonGroup();
        group.add(andCheck);
        group.add(orCheck);
        andCheck.setSelected(true);
        
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(1,3));
        topPanel.add(columnPanel);
        topPanel.add(relationPanel);
        topPanel.add(valuesPanel);
        
        JPanel commandPanel = new JPanel();
        commandField.setMaximumSize(new Dimension(500,30));
        commandPanel.setLayout(new BoxLayout(commandPanel,BoxLayout.Y_AXIS));
        commandPanel.add(topPanel);
        commandPanel.add(Box.createVerticalGlue());
        commandPanel.add(commandField);
/*        
        this.setLayout(new BoxLayout(this,BoxLayout.X_AXIS));
        this.add(commandPanel);
        this.add(andorPanel);
*/
        this.setLayout(new BorderLayout());
        this.add(commandPanel,BorderLayout.CENTER);
        this.add(andorPanel,BorderLayout.EAST);
        
    }
    public void setConfig(SpreadSheet config){
        this.config = config;
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        int n = config.getColumnCount();
        for (int i=0 ; i<n ; ++i){
            Column column = config.getColumn(i);
            if (!config.getColumn(i).getHeader().equals("Tracking") && !config.getColumn(i).getHeader().equals("Reason")){
                String dbColumn = column.getDbColumn();
                if (dbColumn != null){
                    model.addElement(column.getHeader());
                }
            }
        }  
        fieldsBox.setModel(model); 
        fieldsBox.setSelectedItem(null);
    }
    private void setValuesInBox(String dbColumn)throws Exception {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        String sql = String.format("Select distinct %s from %s order by %s" ,dbColumn,config.getDbTable(),dbColumn);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String val = rs.getString(dbColumn);
            if (val != null && !val.equals(""))
                model.addElement(rs.getString(dbColumn));
        }
        valuesBox.setModel(model);
        valuesBox.setSelectedItem(null);
    }
    private void addToCommand(){
        String current = commandField.getText().trim();
        StringBuilder builder = new StringBuilder();
        if (!current.equals("")){
            builder.append(current);
            if (andCheck.isSelected()){
                builder.append(" AND ");
            } else {
                builder.append(" OR ");
            }

        }
        String field = (String) fieldsBox.getSelectedItem();
        int i = config.getColumn(field);
        
        builder.append(config.getColumn(i).getDbColumn());
        builder.append((String)relationBox.getSelectedItem());
        builder.append("\'");
        builder.append(valuesBox.getSelectedItem());
        builder.append("\'");  
        commandField.setText(builder.toString());
    }
    public String getCommand(){
        return commandField.getText().trim();
    }
    SpreadSheet config;
    JComboBox fieldsBox = new JComboBox();
    JComboBox valuesBox = new JComboBox();
    JComboBox relationBox = new JComboBox();
    JCheckBox orCheck = new JCheckBox("OR");
    JCheckBox andCheck = new JCheckBox("AND");
    JTextField commandField = new JTextField();
}
