/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

/**
 *
 * @author gevirl
 */
public class ImageColorsDialog extends JDialog{
    public ImageColorsDialog(ActionListener listen){
        super();
        this.listener = listen;
        this.lineaging = Color.green;
        this.expressing = Color.red;
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS));
        final JColorChooser lineagingChooser = new JColorChooser(this.lineaging);
        lineagingChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                lineaging = lineagingChooser.getColor();
            }
        });
        lineagingChooser.setBorder(new TitledBorder("Lineaging"));
        final JColorChooser expressingChooser = new JColorChooser(this.expressing);
        expressingChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                expressing = expressingChooser.getColor();
            }
        });        
        expressingChooser.setBorder(new TitledBorder("Expressing"));      
        panel.add(lineagingChooser);
        panel.add(Box.createVerticalStrut(30));
        panel.add(expressingChooser);
        content.add(panel,BorderLayout.CENTER);
        
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel,BoxLayout.X_AXIS));
        JButton ok = new JButton("Ok");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                lineaging = lineagingChooser.getColor();
                expressing = expressingChooser.getColor();
                ImageColorsDialog.this.setVisible(false);
                if (listener != null)
                    listener.actionPerformed(e);
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageColorsDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(ok);
        buttonPanel.add(Box.createHorizontalStrut(20));
        buttonPanel.add(cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        content.add(buttonPanel,BorderLayout.SOUTH);
        
        this.setContentPane(content);
        this.setSize(600, 800);
        
    }
    public Color getLineaging(){
        return this.lineaging;
    }
    public Color getExpressing(){
        return this.expressing;
    }
    static public void main(String[] args){
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageColorsDialog dialog = new ImageColorsDialog(null);
                dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
                dialog.setVisible(true);                
            }
        });

    }
    ActionListener listener;
    Color lineaging;
    Color expressing;
}
