/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.GridLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rhwlab.spreadsheet.config.GridSubmission;

/**
 *
 * @author gevirl
 */
public class GridSubmitParametersPanel extends JPanel  {
    public GridSubmitParametersPanel(GridSubmission gs){
        submit = gs;
        buildPanel();
        setToDefault();
    }
    private void buildPanel(){
        GridLayout layout = new GridLayout(7,2);
        this.setLayout(layout);
        
        this.add(new JLabel("Program to Run"));
        this.add(program);
        program.setText(submit.getProgram());
        
        this.add(new JLabel("Cores to Request"));
        this.add(coresField);
        
        this.add(new JLabel("Memory per Core (gigs)"));
        this.add(memoryField);
        
        this.add(new JLabel("Max Runtime (hours)"));
        this.add(hoursField);
        
        this.add(new JLabel("Grid Queue"));
        this.add(queueList);
        DefaultComboBoxModel model = new DefaultComboBoxModel(queues);
        queueList.setModel(model);
        
        this.add(new JLabel("Array Job Range"));
        this.add(arrayjobField);
        
        this.add(new JLabel("Concurrent Tasks"));
        this.add(concurrentField);
        if (submit.getArrayJob()==null){
            arrayjobField.setEnabled(false);
            concurrentField.setEnabled(false);
        }
        
    }
    final public void setToDefault(){
        setCores(submit.getCores());
        setMemory(submit.getMemory());
        setHours(submit.getHours());
        setQueue(submit.getQueue());
        if (submit.getArrayJob()!=null){
            setConcurrent(submit.getConcurrent());
            setArrayjob(submit.getArrayJob());
        }
    }
    public void setCores(int cores){
        coresField.setValue(new Integer(cores));
    }
    public void setMemory(int memory){
        memoryField.setValue(new Integer(memory));
    }
    public void setHours(int hours){
        hoursField.setValue(new Integer(hours));
    } 
    public void setQueue(String s){
        queueList.setSelectedItem(s);
    }
    public void setArrayjob(String s){
        arrayjobField.setText(s);
    }
    public void setConcurrent(int con){
        concurrentField.setValue(new Integer(con));
    }
    
    public Integer getCores(){
        return (Integer)coresField.getValue();
    }
    public Integer getHours(){
        return (Integer)hoursField.getValue();
    }
    public Integer getMemory(){
        return (Integer)memoryField.getValue();
    }
    public Integer getConcurrent(){
        return (Integer)concurrentField.getValue();
    }    
    public String getQueue(){
        return (String)queueList.getSelectedItem();
    }
    public String getArrayjob(){
        return arrayjobField.getText();
    }
    public String getProgram(){
        return submit.getProgram();
    }
    GridSubmission submit;
    JLabel program = new JLabel();
    JFormattedTextField coresField = new JFormattedTextField();
    JFormattedTextField memoryField = new JFormattedTextField();
    JFormattedTextField hoursField = new JFormattedTextField();
    JComboBox queueList = new JComboBox();
    JTextField arrayjobField = new JTextField();
    JFormattedTextField concurrentField = new JFormattedTextField();
    
    static String[] queues  = {"waterston","sage","local"};
    
}
