/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.rhwlab.LMS.RNASeq.FeatureGroup;
import org.rhwlab.LMS.RNASeq.merged.ExpressionID;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.LMS.views.RNASeq.MergedExpressionPanel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;

/**
 *
 * @author gevirl
 */
public class ExportExpressionValuesDialog extends JDialog implements ActionListener{
    public ExportExpressionValuesDialog(SpreadSheetPanel panel){
        this.sourcePanel = panel;
        this.setTitle("Export Expression Values");
        
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel,BoxLayout.X_AXIS));
        filePanel.add(new JLabel("Output File: "));
        filePanel.add(outFileField);
        JButton browseButton  = new JButton("Browse");
        filePanel.add(browseButton);
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
                if (chooser.showSaveDialog(chooser) == JFileChooser.APPROVE_OPTION){
                    File file = chooser.getSelectedFile();
                    outFileField.setText(file.getPath());
                }
            }
        });
        this.add(filePanel,BorderLayout.NORTH);
        
        
        tree = new JTree();
        JScrollPane treeScroll = new JScrollPane(tree);
        treeScroll.setBorder(new TitledBorder(new LineBorder(Color.BLACK),"Samples"));
        this.add(treeScroll,BorderLayout.CENTER);
        
        
        DefaultListModel model = new DefaultListModel();
        FeatureGroup[] features = FeatureGroup.values();
        for (FeatureGroup feature : features){
            model.addElement(feature);
        }
        geneGroupList = new JList(model);
        geneGroupList.setSelectedValue(FeatureGroup.Steep, true);
        JScrollPane scroll = new JScrollPane(geneGroupList);
        scroll.setBorder(new TitledBorder(new LineBorder(Color.BLACK),"Features"));
        this.add(scroll,BorderLayout.EAST);
        
        
        JPanel westPanel = new JPanel();
        westPanel.setLayout(new BoxLayout(westPanel,BoxLayout.Y_AXIS));
        
        JPanel separaterPanel = new JPanel();
        separaterPanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK),"Separater"));
        separaterPanel.setLayout(new BoxLayout(separaterPanel,BoxLayout.Y_AXIS));
        separaterPanel.add(tab);
        separaterPanel.add(comma);
        separaterPanel.add(space);
        group = new ButtonGroup();
        group.add(tab);
        group.add(comma);
        group.add(space);
        space.setSelected(true);
        westPanel.add(separaterPanel);
        
        JPanel headerPanel = new JPanel();
        headerPanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), "File Header"));
        headerPanel.setLayout(new BoxLayout(headerPanel,BoxLayout.Y_AXIS));
        headerPanel.add(noHeader);
        headerPanel.add(sampleTime);
        headerPanel.add(sampleID);
        headerPanel.add(reference);
        ButtonGroup headergroup = new ButtonGroup();
        headergroup.add(noHeader);
        headergroup.add(sampleTime);
        headergroup.add(sampleID);
        headergroup.add(reference);
        noHeader.setSelected(true);     
        westPanel.add(headerPanel);
        this.add(westPanel,BorderLayout.WEST);
        
        okCancel = new OkCancelPanel();
        okCancel.addActionListener(this);
        this.add(okCancel,BorderLayout.SOUTH);
        this.setSize(500,300); 
        this.setLocationRelativeTo(this.sourcePanel);        
    }
    public void init() {
        if (top != null) top.removeAllChildren();
/*        
        if (sourcePanel instanceof TimeSeriesPanel){
            ArrayList<String> idList = new ArrayList<>();
            TimeSeriesPanel timeSeriesPanel = (TimeSeriesPanel)sourcePanel;
            
            top = new DefaultMutableTreeNode("TimeSeries");
            int[] rows = timeSeriesPanel.getConvertedSelectedRows();
            for (int row : rows){
                String timeSeriesID =timeSeriesPanel.getValue(row,"TimeSeriesID");
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(timeSeriesID);
                top.add(node);
                JsonArray jsonArray = (JsonArray)timeSeriesPanel.getValueAsObject(row,"ExpressionIDs");
                TreeMap<Integer,String> map = new TreeMap<>();
                for (int i=0 ; i<jsonArray.size() ; ++i){
                    String expID = jsonArray.getString(i);
                    try {
                        map.put(ExpressionID.getSampleTime(expID),expID);
                    } catch (Exception exc){
                        exc.printStackTrace();
                    }

                }
                for (Integer time : map.navigableKeySet()){
                    String expID = map.get(time);
                    DefaultMutableTreeNode sub = new DefaultMutableTreeNode(expID);
                    node.add(sub);
                    idList.add(expID);                    
                }
            }
            expIDs = idList.toArray(new String[0]);
        }
*/        
        if (sourcePanel instanceof MergedExpressionPanel){
            htseq = false;
            top = new DefaultMutableTreeNode("Expression IDs");
            MergedExpressionPanel expPanel = (MergedExpressionPanel)sourcePanel;
//            top = new DefaultMutableTreeNode("Libraries");
            int[] rows = expPanel.getConvertedSelectedRows(); 
            expIDs = new String[rows.length];
            int i=0;
            for (int row : rows){
                String expID = expPanel.getValue(row,"ExpressionID");
                if (expID.toLowerCase().contains("htseq")){
                    htseq = true;
                }
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(expID);
                top.add(node);
                expIDs[i] = expID;
                ++i;
            }
        }
        DefaultTreeModel model = new DefaultTreeModel(top);
        tree.setModel(model);  
            
    }
    @Override
    public void actionPerformed(ActionEvent e) {
        if (okCancel.isOK()){
            try {
                String f = this.outFileField.getText().trim();
                if (f.equals("")) {
                    JOptionPane.showMessageDialog(this,"Enter an output file");
                    return;
                }
                if (htseq){
                    FeatureGroup selGroup = (FeatureGroup)geneGroupList.getSelectedValue();
                    if (selGroup == FeatureGroup.ALL || selGroup == FeatureGroup.mRNA){
                        JOptionPane.showMessageDialog(LabMan.labMan, "Cannot export transcript expression using HTSeq gene counts");
                        return;
                    }
                }
/*                
                File file = new File(f);
                if (!file.canWrite()){
                    JOptionPane.showMessageDialog(this,String.format("Cannot write to file %s", f));
                    return;                    
                }
        */
                PrintStream stream = new PrintStream(f);
                if (sampleTime.isSelected()){
                    exportTimesHeader(expIDs,separator(),stream);
                }
                else if (sampleID.isSelected()){
                    exportIDsHeader(expIDs,separator(),stream);
                }
                else if (reference.isSelected()){
                    exportReferenceHeader(expIDs,separator(),stream);
                }                
                exportTimeSeriesFile((FeatureGroup)geneGroupList.getSelectedValue(),expIDs,stream,separator());
            }catch (Exception exc){
                exc.printStackTrace();
            }
        } 
        this.setVisible(false);
    }

    private String separator(){
        if (tab.isSelected()){
            return "\t";
        } else if (comma.isSelected()){
            return ",";
        } else if (space.isSelected()){
            return " ";
        }
        return null;
    }
    static public void exportTimesHeader(String[] expIDs,String sep,PrintStream outStream)throws Exception {
        outStream.print("Feature");
        for (String expID : expIDs){
            int time = ExpressionID.getSampleTime(expID);
            outStream.printf("%s%d",sep, time);
        }
        outStream.println();        
    }
    static public void exportReferenceHeader(String[] expIDs,String sep,PrintStream outStream)throws Exception {
        outStream.print("Feature");
        for (String expID : expIDs){
            String ref = ExpressionID.getReference(expID);
            outStream.printf("%s%s",sep, ref);
        }
        outStream.println();        
    }    
    static public void exportIDsHeader(String[] expIDs,String sep,PrintStream outStream)throws Exception {
        outStream.print("Feature");
        for (String expID : expIDs){
            outStream.printf("%s%s",sep, expID);
        }
        outStream.println();        
    }  
    static public void exportTimeSeriesFile(FeatureGroup group,String [] expIDs,PrintStream outStream,String sep) throws Exception {
            
            TreeMap<String,String[]> dataMap = new TreeMap<>();
            for (int i=0 ; i<expIDs.length ; ++i){
                String expID = expIDs[i];
                String infile = ExpressionID.expressionFile(expID, group,true); 
                BufferedReader reader = new BufferedReader(new FileReader(infile));
                String line = reader.readLine();
                while (line != null){
                    String[] tokens = line.split("\t| |,");
                    String[] data = dataMap.get(tokens[0]);
                    if (data == null){
                        data = new String[expIDs.length];
                        dataMap.put(tokens[0], data);
                    }
                    if (tokens.length == 3){
                        data[i] = tokens[2];
                    }else {
                        data[i] = tokens[3];
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
            
            for (String key : dataMap.keySet()){
                String[] data = dataMap.get(key);
                outStream.printf("%s",key);
                for (String v : data){
                    if(v == null){
                        outStream.printf("%sna", sep);
                    }else {
                        outStream.printf("%s%s", sep,v);
                    }
                }
                outStream.println();
            }
        
    }
    // read the data in sample time order
    static private String[] readLines(String[] lines,String[] expIDs,TreeMap<String,BufferedReader> map)throws Exception {
        int i=0;
        for (String id : expIDs){
            BufferedReader reader = map.get(id);
            lines[i] = reader.readLine();
            
            if (lines[i] == null){
                return null;
            }
            ++i;
        }
        return lines;
    }    
    ButtonGroup group;
    JCheckBox tab = new JCheckBox("Tab");
    JCheckBox comma = new JCheckBox("Comma");
    JCheckBox space = new JCheckBox("Space");
    
    JCheckBox noHeader = new JCheckBox("None");
    JCheckBox sampleTime = new JCheckBox("Sample Times");
    JCheckBox sampleID = new JCheckBox("Sample IDs");
    JCheckBox reference = new JCheckBox("Reference");
    
    JFileChooser chooser = new JFileChooser();
    SpreadSheetPanel sourcePanel;
    JTextField outFileField = new JTextField();
    OkCancelPanel okCancel;
    DefaultMutableTreeNode top;
    String[] expIDs;
    JTree tree;
    JList geneGroupList;
    boolean htseq;
}
