/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.spreadsheet.config.SpreadSheet;

/**
 *
 * @author gevirl
 */
public class ChooseColumnsDialog extends JDialog implements ActionListener {
    public ChooseColumnsDialog(SpreadSheet config){
        super(LabMan.labMan,true);
        this.setTitle("Choose Column(s)");
        DefaultListModel model = new DefaultListModel();
        for (String name : config.getSortedColumnHeaders()){
            model.addElement(name);
        }
        jlist = new JList(model);
        
        JScrollPane scroll = new JScrollPane(jlist);
        this.add(scroll,BorderLayout.CENTER);
        okCancel = new OkCancelPanel();
        okCancel.addActionListener(this);
        this.add(okCancel,BorderLayout.SOUTH);
        this.setSize(200,500);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        
        if (okCancel.isOK()){
            selected = jlist.getSelectedValuesList();
        } else {
            selected = null;
        }
        this.setVisible(false);
    }
    public List getSelectedColumns(){
        return selected;
    }
    JList jlist;
    OkCancelPanel okCancel;
    List selected=null;
}
