/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.rhwlab.spreadsheet.Tracking;

/**
 *
 * @author gevirl
 */
public class CheckBoxPanel extends JPanel {
    public CheckBoxPanel(String[] inits){
        
        String[] trackValues = Tracking.getValues();
        boxes = new JCheckBox[trackValues.length+1];
        
        this.setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        allBox = new JCheckBox("All");
        boxes[trackValues.length] = allBox;
        allBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                allChecked();
            }
        });
        this.add(allBox);
        
        for (int i=0 ; i<trackValues.length ; ++i){
            boxes[i] = new JCheckBox(trackValues[i]);
            this.add(boxes[i]);
        }
        
        for (int i=0 ; i<trackValues.length+1 ; ++i){
            for (String init : inits){
                
                if (init.equals(boxes[i].getText())) {
                    boxes[i].setSelected(true);
                    break;
                }
            }
        }
    }
    private void allChecked(){
        if (allBox.isSelected()){
            for (JCheckBox box : boxes){
                box.setSelected(true);
            }
        }else {
            for (JCheckBox box : boxes){
                box.setSelected(false);
            }            
        }
    }
    public String[] getSelected(){
        if (allBox.isSelected()) return null;
        ArrayList<String> list = new ArrayList<String>();
        for (JCheckBox box : boxes){
            if (box.isSelected()){
                list.add(box.getText());
            }
        }
        return list.toArray(new String[0]);
    }
    JCheckBox allBox;
    JCheckBox[] boxes;
}
