/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.rhwlab.LMS.views.TimeSeriesPanel;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;

/**
 *
 * @author gevirl
 */
public class AddUnificationDialog extends JDialog implements ActionListener {
    public AddUnificationDialog(TimeSeriesPanel tsPanel){
        this.tsPanel = tsPanel;
        this.setTitle("Add a Unification");

        
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel,BoxLayout.Y_AXIS));
        this.add(mainPanel,BorderLayout.CENTER);
        
        JPanel userPanel = new JPanel();
        userPanel.setLayout(new BoxLayout(userPanel,BoxLayout.X_AXIS));
        userPanel.add(new JLabel("User: "));
        userPanel.add(new JLabel(System.getProperty("user.name")));
        mainPanel.add(userPanel);
        
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel,BoxLayout.X_AXIS));
        namePanel.add(new JLabel("Name: "));
        namePanel.add(nameField);
        mainPanel.add(namePanel);
        
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel,BoxLayout.X_AXIS));
        descPanel.add(new JLabel("Description: "));
        descPanel.add(descField);
        mainPanel.add(descPanel);
        
        JPanel repPanel = new JPanel();
        repPanel.setLayout(new BoxLayout(repPanel,BoxLayout.Y_AXIS));
        repPanel.add(new JLabel("TimeSeries:"));
        jList = new JList();
        JScrollPane scroll = new JScrollPane(jList);
        repPanel.add(scroll);
        mainPanel.add(repPanel);
        
        okCancel = new OkCancelPanel();
        okCancel.addActionListener(this);
        this.add(okCancel,BorderLayout.SOUTH);
        this.setSize(500,500); 
        this.setLocationRelativeTo(this.tsPanel);
    }
    public void init(){
        int[] rows = tsPanel.getConvertedSelectedRows();
        JsonObjectBuilder objBuilder = Json.createObjectBuilder();
        DefaultListModel listModel = new DefaultListModel();
        for (int row : rows){
            
            objBuilder.add(tsPanel.getValue(row,"TimeSeriesID"), (JsonValue)tsPanel.getValueAsObject(row,"ExpressionIDs"));
            listModel.addElement(tsPanel.getValue(row,"TimeSeriesID"));
        } 
        timeSeries = objBuilder.build();
        jList.setModel(listModel);
    }
    @Override
    public void actionPerformed(ActionEvent e) {
        if (okCancel.isOK()){
            String analysisName = nameField.getText().trim();
            if (analysisName.equals("")){
                JOptionPane.showMessageDialog(this,"Enter a Unification identifier");
                return;
            }
            String referenceTimeSeries = (String)jList.getSelectedValue();
            if (referenceTimeSeries==null){
                JOptionPane.showMessageDialog(this,"Select the reference time series");
                return;                
            }
            // add a new row to the Analysis table
            SpreadSheetPanel uniPanel  = tsPanel.getConfig().getPanel("org.rhwlab.LMS.views.UnificationPanel");
            if (uniPanel != null){
                SpreadSheetModel uniModel = uniPanel.getModel();
                int analysisRow = uniModel.addEmptyRow();
                uniPanel.moveToRow(analysisRow);
                uniModel.setValue(analysisRow,"Name", nameField.getText().trim(), true);
                uniModel.setValue(analysisRow,"Description", descField.getText().trim(), true);
                ListModel listModel = jList.getModel();
                int n = listModel.getSize();

                uniModel.setValue(analysisRow,"TimeSeries",timeSeries, true);
                uniModel.setValue(analysisRow,"ReferenceTimeSeries",referenceTimeSeries, true);
            }
            
        } else {
            
        }
        this.setVisible(false);
    }
    JsonObject timeSeries;
    TimeSeriesPanel tsPanel;
    JList jList;
    OkCancelPanel okCancel;
    JTextField nameField = new JTextField();
    JTextField descField = new JTextField();
}
