/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.rhwlab.LMS.RNASeq.ExpressionID;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;

/**
 *
 * @author gevirl
 */
public class AddConditionDialog extends JDialog implements ActionListener {
    public AddConditionDialog(SpreadSheetPanel rnaSeqPanel){
        
        this.rnaSeqPanel = rnaSeqPanel;
        this.setTitle("Add a Condition");

        
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel,BoxLayout.Y_AXIS));
        this.add(mainPanel,BorderLayout.CENTER);
        
        JPanel userPanel = new JPanel();
        userPanel.setLayout(new BoxLayout(userPanel,BoxLayout.X_AXIS));
        userPanel.add(new JLabel("User: "));
        userPanel.add(new JLabel(System.getProperty("user.name")));
        mainPanel.add(userPanel);
        
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel,BoxLayout.X_AXIS));
        namePanel.add(new JLabel("Condition: "));
        namePanel.add(nameField);
        mainPanel.add(namePanel);
        
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel,BoxLayout.X_AXIS));
        descPanel.add(new JLabel("Description: "));
        descPanel.add(descField);
        mainPanel.add(descPanel);
        
        JPanel repPanel = new JPanel();
        repPanel.setLayout(new BoxLayout(repPanel,BoxLayout.Y_AXIS));
        repPanel.add(new JLabel("Replicants"));
        jList = new JList();
        JScrollPane scroll = new JScrollPane(jList);
        repPanel.add(scroll);
        mainPanel.add(repPanel);
        
        okCancel = new OkCancelPanel();
        okCancel.addActionListener(this);
        this.add(okCancel,BorderLayout.SOUTH);
        this.setSize(200,200);    
        this.setLocationRelativeTo(this.rnaSeqPanel);
    }
    public void init()throws Exception {
        int[] rows = rnaSeqPanel.getConvertedSelectedRows();
        DefaultListModel listModel = new DefaultListModel();
        String expID = null;
        for (int row : rows){
            expID = rnaSeqPanel.getValue(row,"ExpressionID");
            listModel.addElement(expID);
        } 
        reference = ExpressionID.getReference(expID);
        jList.setModel(listModel);
    }
    @Override
    public void actionPerformed(ActionEvent e) {
        if (okCancel.isOK()){
            // is there a condition name
            String condName = nameField.getText().trim();
            if (condName.equals("")){
                JOptionPane.showMessageDialog(this, "Enter and identifier for this condition");
                return;
            }
            // add a new row to the Condition table
            SpreadSheetPanel condPanel  = rnaSeqPanel.getConfig().getPanel("org.rhwlab.LMS.views.ConditionPanel");
            if (condPanel != null){
                SpreadSheetModel condModel = condPanel.getModel();
                int condRow = condModel.addEmptyRow();
                condPanel.moveToRow(condRow);
                condModel.setValue(condRow,"Condition", nameField.getText().trim(), true);
                condModel.setValue(condRow,"Description", descField.getText().trim(), true);
                ListModel listModel = jList.getModel();
                int n = listModel.getSize();
                
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                for (int i=0 ; i<n ; ++i){
                    arrayBuilder.add((String)listModel.getElementAt(i));
                }
                condModel.setValue(condRow,"Replicates",arrayBuilder.build(), true);
                condModel.setValue(condRow,"Reference",reference, true);
            }
            
        } else {
            
        }
        this.setVisible(false);
    }
    String reference;
    SpreadSheetPanel rnaSeqPanel;
    JList jList;
    OkCancelPanel okCancel;
    JTextField nameField = new JTextField();
    JTextField descField = new JTextField();
}
