/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.diag;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.Gene;

/**
 *
 * @author gevirl
 */

// check the crosses backfill spreadshhet for conssitency
public class CheckCrossBackfill {
    public CheckCrossBackfill(String file)throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("Select * from Strain where StrainID=?");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        heads = line.split(",");
        int geneCol = findColumn("Gene");
        int parentCol = findColumn("Parent Strain");
        int strainCol = findColumn("Crossing Strain");
        
        line = reader.readLine();
        while (line != null){
            String[] tokens = line.split(",");
            String gene = tokens[geneCol];
            String strain = tokens[strainCol];
            String parent = tokens[parentCol];
            
            // get the cross strain record from db
            state.setString(1, strain);
            state.execute();
            ResultSet rs = state.getResultSet();
            if (rs.next()){
                String crossGene = rs.getString("Gene");
                
                String progenitor = rs.getString("Progenitor");
                if (!parent.equals(progenitor)){
                    System.out.printf("Cross Strain: %s progenitor %s does not match parent strain: %s\n", strain,progenitor,parent);
                } else {
                    if (gene!=null && crossGene != null && !gene.contains(crossGene)){
                        Gene dbGene = new Gene();
                        dbGene.fromMySqlByCGC(MySql.getMySql(), crossGene);
                        if (!dbGene.getSequenceName().equals(gene)){
                            System.out.printf("Cross Strain %s gene %s does not match db gene %s\n", strain,gene,crossGene);
                        }
                    }else if (gene == null || crossGene==null){
                        System.out.printf("Cross Strain %s gene %s does not match db gene %s\n", strain,gene,crossGene);
                    }
                }
            }else {
                System.out.printf("Cross strain: %s not in DB\n",strain);
            }
            line =reader.readLine();
        }        
    }
    final public int findColumn(String head){
        for (int i=0 ; i<heads.length ; ++i){
            if (head.equals(heads[i])){
                return i;
            }
        }
        return -1;
    }
    static public void main(String[] args)throws Exception {
        for (String arg : args){
            System.out.println(arg);
            CheckCrossBackfill check = new CheckCrossBackfill(arg+".csv");
        }
        
    }
    String[] heads;
}
