/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.diSPIM;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.rhwlab.db.MySql;
import org.rhwlab.grid.GridSubmit;
import org.rhwlab.spreadsheet.GridSubmittable;

/**
 *
 * @author gevirl
 */
public class IPDetection extends Status implements GridSubmittable {
    public IPDetection(){
        super();
        inputs.put("Directory", null);
        inputs.put("diSPIMID", null); 
        inputs.put("Preprocessing",null);
        inputs.put("Lineaging", null);
    }
/*    
    public void submit()throws Exception {
        String pre = inputs.get("Preprocessing").getValueAsString();
        if (pre.equals("")){
            JOptionPane.showMessageDialog(this.panel,"Need to run the Preprocessor first ");
            return;
        }
        Integer line  = ((Lineaging)inputs.get("Lineaging")).pipelineCode();
        if (line == null){
            JOptionPane.showMessageDialog(this.panel,"Specifiy the lineaging channel first ");
            return;
        }
        String dir = inputs.get("Directory").getValueAsString();
        String diSPIM_ID = inputs.get("diSPIMID").getValueAsString();
        
        File scriptFile = makeScript(diSPIM_ID,dir);

        // start the script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile.getPath());
        Process p = pb.start();  
        PreparedStatement state = MySql.getMySql().getStatement("Update diSPIM set Registration = ? where diSPIMID = ?");
        state.setString(1, "Started");
        state.setString(2,diSPIM_ID);
        state.execute();  
        this.setValue("Started");        
    }
    private File makeScript(String diSPIM_ID,String dir)throws Exception {

        File qsubFile = makeQsub(diSPIM_ID,dir);
        File scriptFile = new File(dir,"IPDetection.sh");
        
        PrintStream writer = new PrintStream(scriptFile);
        writer.println("#! /bin/bash"); 
        writer.printf("qsub -e %s -o %s %s\n",dir,dir,qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);        
        return scriptFile;
    }
    private File makeQsub(String diSPIM_ID,String dir)throws Exception {
        Integer line  = ((Lineaging)inputs.get("Lineaging")).pipelineCode();

        // write the qsub file
        File qsubFile = new File(dir,"IPDetection.qsub");
        qsubFile.setWritable(true,false);
        PrintStream qsubStream = new PrintStream(qsubFile);
        qsubStream.println("#$ -S /bin/bash");
        qsubStream.printf("#$ -l mfree=3G\n");
        qsubStream.println("#$ -l h_rt=48:0:0");
        qsubStream.println("cd /nfs/waterston/tools3/SPIM_Registration_pete");
        qsubStream.printf("JAVA_HOME=/nfs/waterston/jdk1.8.0_102 xvfb-run -d /nfs/waterston/tools3/apache-maven-3.3.9/bin/mvn exec:java -Dexec.mainClass=dispim.DispimMain -Dexec.args=\"%s/ true true %d true false 0\" \n",dir,dir,line);

 //       qsubStream.printf("/nfs/waterston/jdk1.8.0_102/bin/java -Xms3G -Xmx3G -classpath /nfs/waterston/tools3/LabManagement.jar org.rhwlab.LMS.diSPIM.IPDetection %s \n",diSPIM_ID);        
        qsubStream.close();
        return qsubFile;        
    } 
*/    
    // entry point to update database after Interest point and registration completed
    static public void main(String[] args) throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("Update diSPIM set Registration = ? where diSPIMID = ?");
        state.setString(1, "Completed");
        state.setString(2, args[0]);       
        state.execute();
    }

    @Override
    public void submit(String prog,int cores, int memory, int hours, String queue, String arrayjob, int concurrent) throws Exception {
        String pre = inputs.get("Preprocessing").getValueAsString();
        if (pre.equals("")){
            JOptionPane.showMessageDialog(this.panel,"Need to run the Preprocessor first ");
            return;
        }
        Integer line  = ((Lineaging)inputs.get("Lineaging")).pipelineCode();
        if (line == null){
            JOptionPane.showMessageDialog(this.panel,"Specifiy the lineaging channel first ");
            return;
        }
        String dir = inputs.get("Directory").getValueAsString();
        File dirFile = new File(dir);
        String diSPIM_ID = inputs.get("diSPIMID").getValueAsString();
        
        GridSubmit gs = new GridSubmit(diSPIM_ID,"InterestPoint",dirFile);
        gs.setRuntime(hours);
        gs.setMemory(memory);
        gs.setSlots(cores);
        gs.setQueue(queue);
        PrintWriter qsubStream = gs.initializeQsub();         
        qsubStream.println("cd /nfs/waterston/tools3/SPIM_Registration_pete");
        qsubStream.printf("JAVA_HOME=/nfs/waterston/jdk1.8.0_102 xvfb-run -d /nfs/waterston/tools3/apache-maven-3.3.9/bin/mvn exec:java -Dexec.mainClass=dispim.DispimMain -Dexec.args=\"%s/ true true %d true false 0\" \n",dir,dir,line);
        ArrayList<String> argsList = new ArrayList();
        argsList.add(diSPIM_ID);
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.diSPIM.IPDetection", argsList);
        gs.run(); 
        
        PreparedStatement state = MySql.getMySql().getStatement("Update diSPIM set Registration = ? where diSPIMID = ?");
        state.setString(1, "Started");
        state.setString(2,diSPIM_ID);
        state.execute();  
        this.setValue("Started");        
    }
}
