/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.diSPIM;

import ij.ImagePlus;
import ij.io.Opener;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class ID extends TextCell{
    public ID(){
        inputs.put("Progenitor", null);
        inputs.put("Count", null);
        inputs.put("TimePoints", null);
        inputs.put("Directory", null);
    }
    public void stateChanged(ChangeEvent event){
        String prog = inputs.get("Progenitor").getValueAsString();
        String count = inputs.get("Count").getValueAsString();
        if (prog.equals("") || count.equals("")) return;
        
        setValue(String.format("%s_%s",prog,count));
        
    }
    public static int[] getDimensions(String diSPIMID)throws Exception {
        int[] ret = new int[3];
        String sql = String.format("Select * from diSPIM where diSPIMID = \"%s\"",diSPIMID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            String dir = rs.getString("Directory");
            File file = new File(new File(dir,"MVR_STACKS"),"TP1_Ch1_Ill0_Ang0,90.tif");
            ImagePlus ip = new Opener().openImage(file.getPath());
            if (ip == null) return null;
            ret[0]=ip.getWidth();
            ret[1] = ip.getHeight();
            ret[2] = ip.getNSlices();
        }
        return ret;
    }
    public void checkStatus() throws Exception {
        String id = this.getValueAsString();
        String dir = inputs.get("Directory").getValueAsString();
        String s = inputs.get("TimePoints").getValueAsString();
        if (s.equals("")){
            JOptionPane.showMessageDialog(panel,String.format("Cannot check status on %s, TimePoints not entered", id));
            return;
        }
        checkStatus(id,dir,Integer.valueOf(s));
    }
    static public void checkStatus(String id,String dir,int timePoints)throws Exception {
        
        PreparedStatement state = MySql.getMySql().getStatement(
                "Update diSPIM set  Preprocessing=? , Registration=? , BoundingBox=? , Deconvolution=? , Segmentation=? where diSPIMID = ?");        
        state.setNull(1, java.sql.Types.VARCHAR);
        state.setNull(2, java.sql.Types.VARCHAR);
        state.setNull(3, java.sql.Types.VARCHAR);
        state.setNull(4, java.sql.Types.VARCHAR);
        state.setNull(5, java.sql.Types.VARCHAR);
        state.setString(6, id);   
        
        
        
        // is the an MVR directory
        File MVR = new File(dir,"MVR_STACKS");
        if (!MVR.exists()) return ;  // nothing has been done
        
        File[] files = MVR.listFiles();
        
        // count the spim files
        int spimCount = 0;
        int tpCount = 0;
        int h5Count = 0;
        boolean registered = false;
        for (File file : files){
            if (file.getName().startsWith("spim")){
                ++spimCount;
            } else if (file.getName().startsWith("TP")&& file.getName().endsWith("tif")){
                ++tpCount;
            } else if (file.getName().endsWith("h5")){
                ++h5Count;
            } else if (file.getName().equals("interestpoints")){
                registered = true;
            }
        }
        spimCount = spimCount/4;
        tpCount = tpCount/2;
        
        
        if (spimCount == timePoints){
            state.setString(1,"Completed");

        } else if (spimCount >0 && spimCount < timePoints){
            state.setString(1,"Error");
        }

        if (registered){
            state.setString(2,"Completed");
        }

        if (tpCount >0){
            state.setString(3,"Completed");
        }

        if (tpCount >= timePoints-1){
            state.setString(4,"Completed");
                        // update the clustering box
            ClusteringBox.update(id);
        } else if (tpCount <timePoints && tpCount >0){
            state.setString(4,"Error");                
        }

        if (h5Count>=timePoints-1){
            state.setString(5,"Completed");   
        }else if (h5Count >0 && h5Count<timePoints) {
            state.setString(5,"Error");
        }
        state.execute();
    }
}
