/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.diSPIM;

import java.sql.PreparedStatement;
import java.util.Map.Entry;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import org.rhwlab.LMS.JsonCell;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class ClusteringBox extends JsonCell {
    
    static public void update(String dispimID) throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("update diSPIM set ClusteringBox = ? where diSPIMID = ?");
        
        int[] dims = ID.getDimensions(dispimID);
        if (dims != null){
            TreeMap<String,Integer> boxMap = new TreeMap<>();
            boxMap.put("xmin",(int)(0.05*dims[0]));
            boxMap.put("xmax",(int)(0.95*dims[0]));
            boxMap.put("ymin",(int)(0.05*dims[1]));
            boxMap.put("ymax",(int)(0.95*dims[1]));
            boxMap.put("zmin",(int)(0.05*dims[2]));
            boxMap.put("zmax",(int)(0.95*dims[2]));  

            //make a json object of the bounding box
            JsonObjectBuilder builder = Json.createObjectBuilder();
            for (Entry<String,Integer> entry : boxMap.entrySet()){
                builder.add(entry.getKey(),entry.getValue());           
            }
            state.setString(1, builder.build().toString());
            state.setString(2, dispimID);
            state.execute();
        }
                
    }
    static public void main(String[] args )throws Exception{
        for (String arg : args){
            ClusteringBox.update(arg);
        }
    }
}
