/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.diSPIM;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class BoundingBox extends Status {
    public BoundingBox(){
        super();
        inputs.put("Directory", null);
        inputs.put("diSPIMID", null); 
        inputs.put("Preprocessing",null);
        
        
    }
    public void run()throws Exception {
        String dir = inputs.get("Directory").getValueAsString();
        String id = inputs.get("diSPIMID").getValueAsString();
        File xml = new File(new File(dir,"MVR_STACKS"),"dataset.xml");
        File script = makeScriptFile(dir,xml);
        String path = script.getPath();
        ProcessBuilder pb = new ProcessBuilder(path);
        Process process = pb.start();
        process.waitFor();
        
        // update the bounding box status
        BufferedReader reader = new BufferedReader(new FileReader(xml));
        String line = reader.readLine();
        while (line != null){
            if (line.contains("My Bounding Box")){
                PreparedStatement state = MySql.getMySql().getStatement("update diSPIM set BoundingBox = ? where diSPIMID = ?");
                state.setString(1, "Completed");
                state.setString(2, id);
                state.execute();
                break;
            }
            line = reader.readLine();
        }
    }
    private File makeScriptFile(String dir,File xml) throws Exception {
        File scriptFile = new File(dir,"BoundingBox.sh");
        PrintStream writer = new PrintStream(scriptFile);
        writer.printf("cd %s\n", "/nfs/waterston/tools3/SPIM_Registration_BoundingBox");
        writer.print("JAVA_HOME=/nfs/waterston/jdk1.8.0_102 ");
        writer.print("M2_HOME=/nfs/waterston/apache-maven-3.3.9 ");
        writer.print("/nfs/waterston/apache-maven-3.3.9/bin/mvn \"-Dexec.args=-classpath %classpath spim.fiji.plugin.Define_Bounding_Box ");
        writer.printf("%s\" -Dexec.executable=/nfs/waterston/jdk1.8.0_102/bin/java org.codehaus.mojo:exec-maven-plugin:1.2.1:exec",xml.getPath());
        writer.close();
        scriptFile.canExecute();
        return scriptFile;
    }
}
