/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.coreg;

import java.io.File;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.encode.ChipSeq.peaks.ClusterReportFile;
import org.rhwlab.chipseq.PeakCluster;
import org.rhwlab.gene.model.Annotation;
import org.rhwlab.gene.model.ModelFromGFF;

/**
 *
 * @author gevirl
 */
// plot frequency of ChipSeq clusters located between gene pairs of an operon vs expression distance of the gene pair
public class GenePairChipSeqClusters extends JFrame {

    public GenePairChipSeqClusters(OperonGenePairs allpairs, ClusterReportFile clusters, String distMeasure, int nBins, int minCl,int maxCl) throws Exception {

        ModelFromGFF gff3 = new ModelFromGFF(new File("/net/waterston/vol9/References/WS245/AllWormBase.withTransposon.gff3"));

        TreeMap<String, String[]> firstPairs = allpairs.getGenePairs(1);
        // find the range of expression distance
        double vMin = Double.MAX_VALUE;
        double vMax = 0.0;
        int col = allpairs.getColumn(distMeasure);
        for (String[] data : firstPairs.values()) {
            double v = Double.valueOf(data[col]);
            if (v > vMax) {
                vMax = v;
            }
            if (v < vMin) {
                vMin = v;
            }
        }
        double delta = (vMax - vMin) / nBins;

        List<PeakCluster> allClusters = clusters.getAllPeakClusters(1000);
        // sort the clusters by chromosome and location
        TreeMap<String, TreeMap<Integer, PeakCluster>> sortedClusters = new TreeMap<>();
        for (PeakCluster cluster : allClusters) {
            int n = cluster.getTFs().size();
            if (n >= minCl && n <= maxCl) {
                String chr = cluster.getChromosome();
                Integer loc = cluster.getMeanPosition();
                TreeMap<Integer, PeakCluster> chrClusters = sortedClusters.get(chr);
                if (chrClusters == null) {
                    chrClusters = new TreeMap<>();
                    sortedClusters.put(chr, chrClusters);
                }
                chrClusters.put(loc, cluster);
            }
        }
        // bin the pairs by expression distance
        int[] total = new int[nBins];
        int[] count = new int[nBins];
        int gene1Col = allpairs.getColumn("Gene1");
        int gene2Col = allpairs.getColumn("Gene2");
        for (String[] data : firstPairs.values()) {
            String wbGene1 = gff3.getWBGene(data[gene1Col]);
            String wbGene2 = gff3.getWBGene(data[gene2Col]);
            Annotation annot1 = gff3.getGeneAnnotation(wbGene1);
            Annotation annot2 = gff3.getGeneAnnotation(wbGene2);
            int low, high;
            if (annot1.getStrand().equals("+")) {
                low = annot1.getEnd();
                high = annot2.getEnd();
            } else {
                low = annot2.getStart();
                high = annot1.getStart();
            }
            double v = Double.valueOf(data[col]);
            int bin = Math.min((int) ((v - vMin) / delta), nBins - 1);
            ++total[bin];
            TreeMap<Integer, PeakCluster> chrMap = sortedClusters.get(annot1.getChromosome());
            Integer ceil = chrMap.ceilingKey(low);
            if (ceil < high) {
                ++count[bin];
            }
        }
        XYSeriesCollection collect = new XYSeriesCollection();
        XYSeries series = new XYSeries("");
        for (int i = 0; i < count.length; ++i) {
            series.add(vMin + delta * i, (double) count[i] / (double) total[i]);
        }
        collect.addSeries(series);
        /*        
        NumberAxis axis = new NumberAxis(distMeasure);
        axis.setAutoRangeIncludesZero(false);
        ValueAxis domainAxis = axis;

        ValueAxis valueAxis = new NumberAxis("% with ChipSeq cluster");

        XYBarRenderer renderer = new XYBarRenderer();


        XYPlot plot = new XYPlot(collect, domainAxis, valueAxis, renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);

        JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT,
                plot, false);
         */
        JFreeChart chart = ChartFactory.createXYBarChart(String.format("Cluster sizes: %d - %d",minCl,maxCl), String.format("Expression Difference (%s)",distMeasure), false, "% of First Gene Pairs ", collect, PlotOrientation.VERTICAL, false, false, false);
        ChartPanel panel = new ChartPanel(chart);
        this.setContentPane(panel);
    }

    public static void main(String[] args) throws Exception {
        ClusterReportFile clusterFile = new ClusterReportFile(new File("/net/waterston/vol2/home/gevirl/PeakClusters.tab"));
        File file = new File("/net/waterston/vol2/home/gevirl/FACS/OperonStudy.csv");
        OperonGenePairs pairs = new OperonGenePairs(file);

        GenePairChipSeqClusters genepairs = new GenePairChipSeqClusters(pairs, clusterFile, "ManhattanDistance", 10,3,1000);

        genepairs.pack();
        genepairs.setSize(500, 500);
        genepairs.setVisible(true);
        genepairs.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
}
