/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe;

import java.awt.BorderLayout;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.math.plot.Plot2DPanel;
import org.rhwlab.LMS.RNASeq.TpmFeatureGroup;
import org.rhwlab.LMS.RNASeq.merged.ExpressionDirectory;
import org.rhwlab.LMS.RNASeq.merged.ExpressionID;
import org.rhwlab.RNASeq.PCA;

/**
 *
 * @author gevirl
 */
public class ExpressionDataFrame extends org.rhwlab.LMS.dataframe.DataFrame  {
    
    public ExpressionDataFrame(String[] expIDs,TpmFeatureGroup group)throws Exception {
        super();
        this.setName(String.format("FACS_%s",group.toString()));
        String[] geneIDs = new String[3];
        geneIDs[0] = "SequenceName";
        geneIDs[1] = "CommonName";
        geneIDs[2] = "TranscriptType";

        this.setHeaders(geneIDs);
        this.setHeaders(expIDs);
        for (int j=0 ; j<expIDs.length ; ++j){
            try {
                String file = ExpressionID.tpmExpressionFile(expIDs[j], group, "gene");
                List<String[]> dataList = ExpressionDirectory.readFile(file);
                if (frame.isEmpty()){
                    Iterator<String[]> dataIter = dataList.iterator();
                    while (dataIter.hasNext()){
                        String[] data = dataIter.next();
                        ArrayList<String> list = new ArrayList<>();
                        frame.add(list);
                        for (String value : data){
                            list.add(value);
                        }
                    }
                }
                else {
                    Iterator<ArrayList<String>> frameIter = frame.iterator();
                    Iterator<String[]> dataIter = dataList.iterator();
                    while (dataIter.hasNext()){
                        String[] data = dataIter.next();
                        ArrayList<String> frameRow = frameIter.next();
                        frameRow.add(data[3]);
                    }
                }

            } catch (Exception exc){
                exc.printStackTrace();
                return;
            }
        }        
    }

    public void plot(String first,String last){
        double[][] x = this.getAsDouble(this.column(first),this.column(last));
        double[] avg = new double[this.getSize()];
        double[] max = new double[this.getSize()];
        for (int i=0 ; i<avg.length ; ++i){
            max[i] = 0.0;
            avg[i] = 0.0;
        }
        // find the average and the max
        for (int r=0 ; r<x.length ; ++r){
            for (int c=0 ; c<x[r].length ; ++c){
                avg[r] = avg[r] + x[r][c];
                if (x[r][c] > max[r]){
                    max[r] = x[r][c];
                }
            }
            avg[r] = avg[r]/x[r].length;
        }
        
       Arrays.sort(max);
      
        Plot2DPanel plot = new Plot2DPanel();
        plot.addLinePlot("Max", max);
        JFrame plotframe = new JFrame();
        plotframe.getContentPane().setLayout(new BorderLayout());
        plotframe.add(plot,BorderLayout.CENTER);
        
//        plot.addScatterPlot("Max vs avg", Color.black, avg,max);
        plotframe.pack();	
        plotframe.setSize(900,600);        
        plotframe.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        plotframe.setVisible(true);        
        
    
    }




}
