/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.cross;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.models.CrossingModel;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class Attempt extends IntegerCell {
    public Attempt(){
        this("");
    }
    public Attempt(String id){
        super(id);
        inputs.put("OffSpringStrain",null);
    }
    @Override
    public void stateChanged(ChangeEvent ce) {
        // get the transcript
        CellBase base = inputs.get("OffSpringStrain");
        String crossID = base.getValueAsString();
        
        // get the next design value
        CrossingModel crossModel = (CrossingModel)this.getModel();
        int n = 0;
        try {
            n = crossModel.nextAttempt(crossID,this.getRow());
        }catch(Exception exc){exc.printStackTrace();}
        
        this.setValue(Integer.toString(n));
        this.unlock();
    }     
}
