insert into RNASequencing (SequencingID) select HiseqID SequencingID from Hiseq 

update RNASequencing S , Hiseq M set
S.UserName = 'alhigdon',
S.LibraryID = M.cDNAID,
S.SequencingCount = M.cDNACount,
S.SequencingID = M.HiseqID,
S.DataSetID = M.DataSet,
S.Received = M.DateReceived,
S.Platform = 'HiSeq',
S.FlowCellBarcode = M.FlowCellBarcode,
S.Genome = 'WS245',
S.Aligner = 'STAR',
S.ExpressionBy = 'BitSeq',
S.Fastq1 = concat(M.AlignDir,'/',M.FastqFile),
S.Fastq2 = concat(M.AlignDir,'/',M.FastqFile),
S.Gene = M.Gene,
S.WBGene = M.WBGene,
S.Directory = concat('/net/waterston/vol9/RNASeq/',S.UserName,'/',S.DataSetID,'/',S.SequencingID),
S.SequencingDate = M.RunDate
where S.SequencingID = M.HiseqID

update RNASequencing S set 
S.Directory = concat('/net/waterston/vol9/RNASeq/',S.UserName,'/',S.DataSetID,'/',S.SequencingID)
where Platform='HiSeq'

select UserName,DataSetID,SequencingID,Directory from RNASequencing where Platform='HiSeq'