/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.clone;

import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.spreadsheet.SpreadSheetModel;

/**
 *
 * @author gevirl
 */
public class CloneId extends TextCell {
     public CloneId(){
        this.inputs.put("ConstructID",null);
        this.inputs.put("Clone#",null);
    }
    public void stateChanged(ChangeEvent ce) {
        String construct = inputs.get("ConstructID").getValueAsString();
        if (construct.equals("")){
            this.setValue("");
            return;
        }
        String cloneNo = inputs.get("Clone#").getValueAsString(); 
        if (cloneNo.equals("")){
            this.setValue("");
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(construct);
        builder.append("#");
        builder.append(cloneNo);
        String newValue = builder.toString();
        if (validate(newValue)){
            this.setValue(newValue);
        }else {
                JOptionPane.showMessageDialog(LabMan.labMan, "Duplicate Clone ID");
                this.setValue("");            
        }
    }
    @Override
    public boolean validate(String newValue) {
        if (!validate) return true;
        // check that the newValue is not already present in the table
        SpreadSheetModel m = (SpreadSheetModel)this.getModel();
        return !m.isPresent(newValue, this.getColumn());

    }     
}
