/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.cDNA;

import java.sql.ResultSet;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.models.cDNAModel;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class SampleCount extends IntegerCell {
    public SampleCount(){
        this("");
    }
    public SampleCount(String id){
        super(id);
        inputs.put("RNASampleID",null);
    }    
    
    @Override
    public void stateChanged(ChangeEvent ce) {
        // get the transcript
        CellBase base = (CellBase)inputs.get("RNASampleID");
        if (base == null)return;
        String sample = base.getValueAsString();
        if (sample.equals("")) return;
        
        // get the next design value
        cDNAModel sampleModel = (cDNAModel)this.getModel();
        int cDNA = 0;
        try {
            cDNA = sampleModel.nextcDNA(sample,this.getRow());
        }catch(Exception exc){exc.printStackTrace();}
        
        this.setValue(Integer.toString(cDNA));
        this.unlock();
        
        
    }    
     
}
