/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis.views;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/**
 *
 * @author gevirl
 */
public class TrackingAnalysisFrame extends JFrame  implements ContainerListener {
    public TrackingAnalysisFrame()throws Exception {
        centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel,BoxLayout.Y_AXIS));
        JScrollPane scroll = new JScrollPane(centerPanel);  
        centerPanel.addContainerListener(this);
        
        FilterTablePanel filterPanel = new FilterTablePanel(this,centerPanel);
        FilterResultsPanel resultsPanel = new FilterResultsPanel(this);
        filterPanel.addListener(resultsPanel);
        TrackingPanel trackingPanel = new TrackingPanel(filterPanel,centerPanel);
        JPanel westPanel = new JPanel();
        westPanel.setLayout(new BoxLayout(westPanel,BoxLayout.Y_AXIS));
        westPanel.add(filterPanel);
        westPanel.add(Box.createVerticalStrut(10));
        westPanel.add(resultsPanel);
        westPanel.add(Box.createVerticalStrut(10));
        westPanel.add(trackingPanel);
        
        JButton clear = new JButton("Clear");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                centerPanel.removeAll();
            }
        });
        JPanel southPanel = new JPanel();
        southPanel.add(clear);
        
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add(westPanel,BorderLayout.WEST);
        content.add(scroll,BorderLayout.CENTER);
        content.add(southPanel,BorderLayout.SOUTH);
        this.add(content);
        this.pack();        
    }

    @Override
    public void componentAdded(ContainerEvent e) {
//        this.validateTree();
        this.validate();
        this.repaint();
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
//        this.validateTree();
        this.validate();
        this.repaint();
    } 
    JPanel centerPanel;
    
    static public void main(String[] args){
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                frame = new TrackingAnalysisFrame();
                frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                frame.setSize(800, 500);
                frame.setTitle("Tracking Analysis");
                frame.setVisible(true);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
    }
    static public TrackingAnalysisFrame frame;

}
