/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis.views;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.rhwlab.LMS.analysis.TrackingJoin;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class TableTrackingPanel extends JPanel {
    public TableTrackingPanel(TrackingPanel trackingPanel,JPanel displayPanel)throws Exception {
        this.display = displayPanel;
        this.trackingPanel = trackingPanel;        
        DefaultListModel model = new DefaultListModel();
        String sql = "Select distinct DBTable from LMSTracking order by DBTable";
        ResultSet rs = MySql.getMySql().execute(sql);
        while(rs.next()){
            model.addElement(rs.getString("DBTable"));
        }
        tableList = new JList(model);
        
        this.setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        this.add(new JLabel("Tables"));
        JScrollPane scroll = new JScrollPane(tableList);
        this.add(scroll);
        JButton submit = new JButton("Submit");
        submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    submit();
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });        
        this.add(submit);
    }
    private void submit()throws Exception {
        List projects = trackingPanel.getSelectedProjects();
        List statusList = trackingPanel.getSelectedStatus();
        
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel,BoxLayout.Y_AXIS));
        
        for (Object  obj : trackingPanel.getSelectedTables()){
            String table =  (String) obj;
            DefaultTableModel model = new DefaultTableModel();
            model.addColumn("Status");
            for (Object pObj : projects){
                model.addColumn((String)pObj);   
            }
            model.addColumn("Total"); 
            int[] colTotals = new int[projects.size()];
            String joinName = trackingPanel.getTableName(table);
            TrackingJoin join = new TrackingJoin(joinName,table);
            
            for (Object sobj : statusList){               
                String status = (String)sobj;
                
                Object[] row = new Object[projects.size()+2];
                row[0] = status;
                int rowTotal = 0;
                for (int i=1 ; i<row.length-1 ; ++i){
                    String project = (String)projects.get(i-1);
                    Integer v = join.getCount(status, project);
                    row[i] = v;
                    if (v != null){
                        rowTotal = rowTotal + v;
                        colTotals[i-1] = colTotals[i-1] + v;
                    }
                    
                }
                row[row.length-1] = rowTotal;
                model.addRow(row);
            }
            Object[] row = new Object[projects.size()+2];
            row[0] = "Total";
            int total = 0;
            for (int i=1 ; i<row.length-1;++i){
                row[i] = colTotals[i-1];
                total = total + colTotals[i-1];
            }
            row[row.length-1] = total;
            model.addRow(row);  
            
            JTable jtable = new JTable(model);
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createRaisedBevelBorder());
            panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS)); 
            panel.add(new JLabel(table));
            JPanel tablePanel = new JPanel();
            tablePanel.setLayout(new BorderLayout());
            tablePanel.add(jtable.getTableHeader(),BorderLayout.PAGE_START);
            tablePanel.add(jtable,BorderLayout.CENTER);
            panel.add(tablePanel);
            mainPanel.add(panel);            
        }

        JScrollPane scroll = new JScrollPane(mainPanel);
        display.add(scroll);         
    }
    public List getSelected(){
        return tableList.getSelectedValuesList();
    }
    TrackingPanel trackingPanel;
    JPanel display;    
    JList tableList;
}
