/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis.views;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jfree.data.category.DefaultCategoryDataset;
import org.rhwlab.LMS.analysis.BombEvent;
import org.rhwlab.LMS.analysis.BombSelection;

/**
 *
 * @author gevirl
 */
public class SelectionTable extends JPanel {
    public SelectionTable(String attributeName,BombSelection select)throws Exception {
        // make the set of genes for all the bomb dates
        TreeMap<String,Integer> genes = new TreeMap<>();
        for (Date date : select.getBombDates()){
            for (BombEvent event : select.getBombEvents(date)){
                genes.put(event.GeneName(),0);
            }
        }
        
        // make the table columns
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn(attributeName);
        int col = 1;
        for (String gene : genes.keySet()){
            model.addColumn(gene);
            genes.put(gene, col);
            ++col;
        }
        model.addColumn("Constructs");
        int constructCol = model.getColumnCount()-1;
        model.addColumn("Total");
        int totalCol = model.getColumnCount()-1;
        model.addColumn("Ratio");
        int ratioCol = model.getColumnCount()-1;
        
        // determine the method to use to get the data from the event
        Method method=null;
        Class beanClass = Class.forName("org.rhwlab.LMS.analysis.BombEvent");
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        PropertyDescriptor[] descrs = beanInfo.getPropertyDescriptors();
        for (PropertyDescriptor descr : descrs){
            
            DefaultCategoryDataset dataSet = new DefaultCategoryDataset();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            if(descr.getName().equals(attributeName)){
                method = descr.getReadMethod();
                break;
            }
        }
        
        // add all the rows to the table
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (Date date : select.getBombDates()){
            double total = 0;
            model.addRow(new Object[0]);
            int row = model.getRowCount()-1;
            
            String dateStr = format.format(date);
            model.setValueAt(dateStr, row, 0);
            
            List<BombEvent> events = select.getBombEvents(date);
            for (BombEvent event : events){
                Object data = method.invoke(event);
                String gene = event.GeneName();
                double v=0.0;
                if (data instanceof Integer){
                    v = (Integer)data;
                } else if (data instanceof Double){
                    v = (Double)data;
                }
                total = total + v;
                col = genes.get(gene);
                model.setValueAt(v, row, col);
            }
            model.setValueAt(total, row, totalCol);
            model.setValueAt(events.size(), row, constructCol);
            model.setValueAt(total/events.size(), row, ratioCol);
        }
        JTable table = new JTable(model);
        JScrollPane scroll = new JScrollPane(table);
        this.add(scroll);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
//        table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        table.setFillsViewportHeight(true);        
    }    
}
