/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis.views;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.LMS.analysis.BombEvent;
import org.rhwlab.LMS.analysis.BombSelection;

/**
 *
 * @author gevirl
 */
public class ScatterPlot extends JPanel {
    public ScatterPlot(String xDataName,String yDataName,BombSelection select)throws Exception {
        Class beanClass = Class.forName("org.rhwlab.LMS.analysis.BombEvent");
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        PropertyDescriptor[] descrs = beanInfo.getPropertyDescriptors();
        Method xDataMethod = null;
        Method yDataMethod = null;
        for (PropertyDescriptor descr : descrs){
            if(descr.getName().equals(xDataName)){
                xDataMethod = descr.getReadMethod();
                break;
            }
        }
        for (PropertyDescriptor descr : descrs){
            if(descr.getName().equals(yDataName)){
                yDataMethod = descr.getReadMethod();
                break;
            }
        }        
            
        XYSeriesCollection collect = new XYSeriesCollection();
        XYSeries series = new XYSeries("");
        collect.addSeries(series);
        Set<Date> dates = select.getBombDates();
        double xTotal = 0.0;
        double yTotal = 0.0;
        int count = 0;
        for (Date date : dates){
            List<BombEvent> events = select.getBombEvents(date);
            for (BombEvent event : events){
                ++count;
                Object xdata = xDataMethod.invoke(event);
                Object ydata = yDataMethod.invoke(event);
                if (xdata != null && ydata != null){
                    double x=0.0;
                    if (xdata instanceof Integer){
                        x = (Integer)xdata;
                    } else if (xdata instanceof Double){
                        x = (Double)xdata;
                    }
                    double y=0.0;
                    if (ydata instanceof Integer){
                        y = (Integer)ydata;
                    } else if (ydata instanceof Double){
                        y = (Double)ydata;
                    }  
                    xTotal = xTotal + x;
                    yTotal = yTotal + y;
                    series.add(x,y);
                }
            }
        }
        meanX = xTotal/count;
        meanY = yTotal/count;
                
        JFreeChart chart = ChartFactory.createScatterPlot
                (select.getTitle(),xDataName,yDataName, collect, PlotOrientation.VERTICAL,false,true,true);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYDotRenderer renderer = new XYDotRenderer();
        renderer.setDotHeight(2);
        renderer.setDotWidth(2);
        plot.setRenderer(renderer);
        ChartPanel panel = new ChartPanel(chart);
        this.add(panel);
        return;
            
        }
    public Map getSummary(){
        TreeMap<String,Double> ret = new TreeMap<>();
        ret.put("MeanX", meanX);
        ret.put("MeanY", meanY);
        return ret;
    }    
    double meanX;
    double meanY;
        
}
