/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis.views;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.rhwlab.LMS.analysis.FilterCondition;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class FilterConditionDialog extends JDialog{
    public FilterConditionDialog(Frame frame)throws Exception {
        super(frame,"Define a Filtering Condition",true);
        this.setSize(700, 300);
        JPanel listsPanel = new JPanel();
        listsPanel.setLayout(new BoxLayout(listsPanel,BoxLayout.X_AXIS));
        
        tableList = new JList(buildTableList().toArray(new String[0]));
        tableList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        tableList.addListSelectionListener(new ListSelectionListener(){
            @Override
            public void valueChanged(ListSelectionEvent e) {
                try {
                    buildFieldList((String)tableList.getSelectedValue());
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel,BoxLayout.Y_AXIS));
        tablePanel.add(new JLabel("Table"));
        JScrollPane tableScroll = new JScrollPane(tableList);
        tablePanel.add(tableScroll);
        
        fieldList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        fieldList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                try {
                    buildValueList((String)fieldList.getSelectedValue());
                } catch (Exception exc){
                    exc.printStackTrace();
                }               
            }
        });
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new BoxLayout(fieldPanel,BoxLayout.Y_AXIS));
        fieldPanel.add(new JLabel("Field"));
        JScrollPane fieldScroll = new JScrollPane(fieldList);
        fieldPanel.add(fieldScroll);
        
        opList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        JPanel opPanel = new JPanel();
        opPanel.setLayout(new BoxLayout(opPanel,BoxLayout.Y_AXIS));
        opPanel.add(new JLabel("Operator"));
        JScrollPane opScroll = new JScrollPane(opList);
        opPanel.add(opScroll);
        
        valueList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        JPanel valuePanel = new JPanel();
        valuePanel.setLayout(new BoxLayout(valuePanel,BoxLayout.Y_AXIS));
        valuePanel.add(new JLabel("Value"));
        JScrollPane valueScroll = new JScrollPane(valueList);
        valuePanel.add(valueScroll);
        
        listsPanel.add(tablePanel);
        listsPanel.add(fieldPanel);
        listsPanel.add(opPanel);
        listsPanel.add(valuePanel);
        
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel,BoxLayout.X_AXIS));
        JButton okButton = new JButton("Ok");
        JButton cancelButton = new JButton("Cancel");
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(Box.createHorizontalGlue());
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                condition = ok();
                if (condition != null){
                    FilterConditionDialog.this.setVisible(false);
                } else {
                    JOptionPane.showMessageDialog(rootPane,"Please complete the condition");
                }
            }
        });        
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterConditionDialog.this.setVisible(false);
                condition = null;
            }
        });
        
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add(listsPanel,BorderLayout.CENTER);
        mainPanel.add(buttonPanel,BorderLayout.SOUTH);
        
        this.setContentPane(mainPanel);
        
    }
    private FilterCondition ok(){
        String table = (String)tableList.getSelectedValue();
        String field = (String)fieldList.getSelectedValue();
        String op = (String)opList.getSelectedValue();
        String value = (String)valueList.getSelectedValue();
        if (table!=null && field!=null && op!=null && value!=null){
            return new FilterCondition(table,field,op,value);
        }
        return null;
    }
    private void buildFieldList(String table)throws Exception {
        this.selectedTable = table;
        String sql = String.format("select column_name from information_schema.columns where table_name=\'%s\' order by column_name", table);
        ResultSet rs = MySql.getMySql().execute(sql);
        DefaultListModel model = new DefaultListModel();
        while (rs.next()) {
            model.addElement(rs.getString("column_name"));
        }
        fieldList.setModel(model);
    }
    private void buildValueList(String field)throws Exception{
        if (field == null) return;
        String sql = String.format("select distinct %s from %s order by %s",field,selectedTable,field);
        ResultSet rs = MySql.getMySql().execute(sql);
        DefaultListModel model = new DefaultListModel();
        while (rs.next()) {
            String v = rs.getString(field);
            if (v != null){
                if (v.equals("")){
                    v = " ";
                }
                model.addElement(v);
            }
            else {
                model.addElement("null");
            }
        }
        valueList.setModel(model);                
    }
    private List<String> buildTableList()throws Exception {
        ArrayList<String> ret = new ArrayList<>();
        String sql = "Select distinct DBTable from LMSTracking order by DBTable";
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            ret.add(rs.getString("DBTable"));
        }
        return ret;
    }
    public FilterCondition getCondition(){
        return this.condition;
    }
    static String[] ops = {"=","<",">","<=",">=","!="};
    JList tableList;
    JList fieldList = new JList();
    JList opList = new JList(ops);
    JList valueList = new JList();
    String selectedTable;
    FilterCondition condition;
}
