/*
 * To change mainPanel template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis.views;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.LMS.analysis.BombSelection;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class BombSelectionPanel extends JPanel {
    public BombSelectionPanel(JFrame frame) throws Exception {
        dialog = new DateDialog(frame);
        this.setBorder(new TitledBorder("Bomb Selection"));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(5,1));
        

        JPanel genePanel = new JPanel();
        genePanel.add(new JLabel("Gene Group"));
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        String sql = "Select distinct GroupName from GeneGroups";
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            model.addElement(rs.getString("GroupName"));
        }
        groupBox = new JComboBox(model);
        genePanel.add(groupBox);
        mainPanel.add(genePanel);  
        
        JPanel constructPanel = new JPanel();
        constructPanel.add(new JLabel("Construct"));
        constructBox = new JComboBox(new DefaultComboBoxModel(constructs));
        constructPanel.add(constructBox);
        mainPanel.add(constructPanel); 
        
        JPanel startPanel = new JPanel();
        startPanel.setLayout(new BoxLayout(startPanel,BoxLayout.X_AXIS));        
        startPanel.add(new JLabel("Starting"));
        startDateButton = new JButton("2006-01-01");
        startPanel.add(startDateButton);
        startDateButton.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Date date = dateFormat.parse(startDateButton.getText());
                    dialog.setDate(date);
                    dialog.setTitle("Starting Date");
                    dialog.setVisible(true);
                    if (dialog.isAccepted()){
                        date = dialog.getDate();
                        startDateButton.setText(dateFormat.format(date));
                    }
                } catch(Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        mainPanel.add(startPanel);
        
        JPanel endPanel = new JPanel();
        endPanel.setLayout(new BoxLayout(endPanel,BoxLayout.X_AXIS));
        endPanel.add(new JLabel("Ending"));
        endDateButton = new JButton(dateFormat.format(new Date()));
        endDateButton.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Date date = dateFormat.parse(endDateButton.getText());
                    dialog.setDate(date);
                    dialog.setTitle("Ending Date");
                    dialog.setVisible(true);
                    if (dialog.isAccepted()){
                        date = dialog.getDate();
                        endDateButton.setText(dateFormat.format(date));
                    }
                } catch(Exception exc){
                    exc.printStackTrace();
                }
            }
        });        
        endPanel.add(endDateButton);
        mainPanel.add(endPanel);
        
        submitButton = new JButton("Submit");
        submitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    selectBombs();
                } catch(Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        mainPanel.add(submitButton);        
        
        this.add(mainPanel);
        

    }
    private void selectBombs()throws Exception {
        Date startDate = new java.sql.Date(dateFormat.parse(startDateButton.getText()).getTime());
        Date endDate = new java.sql.Date(dateFormat.parse(endDateButton.getText()).getTime());
        String group = (String)groupBox.getSelectedItem();
        String type = (String)constructBox.getSelectedItem();
        selection = new BombSelection(startDate,endDate,type,group);

        notifyListeners();
        
    }
    private void notifyListeners(){
        ChangeEvent event = new ChangeEvent(selection);
        for (ChangeListener listen : listeners){
            listen.stateChanged(event);
        }
    }
    public void addListener(ChangeListener listener){
        listeners.add(listener);
    }
    BombSelection selection;
    List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    String[] constructs = {"Plasmid","Fosmid","Both"};
    DateDialog dialog;
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    JButton startDateButton;
    JButton endDateButton;
    JButton submitButton;
    JComboBox constructBox;
    JComboBox groupBox;
}
