/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis.views;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/**
 *
 * @author gevirl
 */
public class BombAnalysisFrame extends JFrame implements ContainerListener{
    public BombAnalysisFrame()throws Exception {
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel,BoxLayout.Y_AXIS));
        JScrollPane scroll = new JScrollPane(centerPanel);
        centerPanel.addContainerListener(this);
        
        JPanel eastPanel = new JPanel();
        eastPanel.setLayout(new BoxLayout(eastPanel,BoxLayout.Y_AXIS));
        BombSelectionPanel bombSelect = new BombSelectionPanel(this);
        eastPanel.add(bombSelect);
        
        BombSelectionSummaryPanel summaryPanel = new BombSelectionSummaryPanel();
        eastPanel.add(summaryPanel);
        bombSelect.addListener(summaryPanel);
        eastPanel.add(Box.createVerticalGlue());
        
        
        
        
        
        JPanel westPanel = new JPanel();
        westPanel.setLayout(new BoxLayout(westPanel,BoxLayout.Y_AXIS));
        PlotSelectionPanel plotSelect  = new PlotSelectionPanel(centerPanel);
        bombSelect.addListener(plotSelect);
        westPanel.add(plotSelect);
        
        PlotSelectionSummaryPanel plotSummaryPanel = new PlotSelectionSummaryPanel();
        westPanel.add(plotSummaryPanel);
        plotSelect.addListener(plotSummaryPanel);
        
        
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add(eastPanel,BorderLayout.EAST);
        content.add(westPanel,BorderLayout.WEST);
        content.add(scroll,BorderLayout.CENTER);
        this.add(content);
        this.pack();
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.validateTree();
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.validateTree();
        this.repaint();
    }    
    static public void main(String[] args){
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                frame = new BombAnalysisFrame();
                frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                frame.setSize(800, 500);
                frame.setTitle("Bomb Analysis");
                frame.setVisible(true);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
    }
    static public BombAnalysisFrame frame;

}
