/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class TrackingJoin  {
    public TrackingJoin(String tempTable,String permTable) throws Exception {
        StringBuilder builder = new StringBuilder(tempTable);
        builder.append(".");
        builder.append(primaryKey(permTable));
        String sql = String.format("select L.Project,L.Status from %s left join LMSTracking L on L.ID=%s where L.DBTable = \'%s\'",
                tempTable,builder.toString(),permTable);
        ResultSet rs = MySql.getMySql().execute(sql);
        while(rs.next()){
            String status = rs.getString("Status");
            String project = rs.getString("Project");
            HashMap<String,Integer> counts = countsMap.get(status);
            if (counts == null){
                counts = new HashMap<>();
                countsMap.put(status, counts);
            }
            Integer count = counts.get(project);
            if (count == null){
                count = new Integer(1);
                counts.put(project, count);
            } else {
                counts.put(project,new Integer(count+1));
            }
        }
    }
    public String whereClause(){
        StringBuilder builder = new StringBuilder("");
        
        if (!statusList.isEmpty() || !projectList.isEmpty()) builder.append("where ");
        boolean first = true;
        for (String status : statusList){
            if (first) {
                builder.append("(");
            } else {
                builder.append(" or ");
            }
            builder.append(String.format("Status=\'%s\' ",status));
            first = false;
        }
        if (!first) builder.append(")");
        
        first = true;
        for (String project : projectList){
            if (!statusList.isEmpty()) builder.append(" and ");
            if (first) {
                builder.append("(");
            } else {
                builder.append(" or ");
            }
            builder.append(String.format("Project=\'%s\' ",project));
            first = false;            
        }
        if (!first) builder.append(")");
        return builder.toString();
    }
    private String primaryKey(String table) throws Exception {
        String sql = String.format("select column_name from information_schema.columns where table_name=\'%s\' and column_key=\'PRI\'", table);
        ResultSet rs = MySql.getMySql().execute(sql);   
        rs.next();
        return rs.getString("column_name");
    }
    public Integer getCount(String status,String project){
        HashMap<String,Integer> counts=countsMap.get(status);
        if (counts != null){
            return counts.get(project);
        }else {
            return null;
        }
    }
    List<String> statusList;
    List<String> projectList;
    HashMap<String,HashMap<String,Integer>> countsMap = new HashMap<>();
}
