/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis;

import java.awt.Dimension;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class FilteredTable {
    public FilteredTable(List<FilterCondition> conds,boolean and)throws Exception{
        if (conds.size()==0) return;
        
        sourceTable = conds.get(0).getTable();
        tempTable = sourceTable+System.getenv("USER");
        // erase the previous temp table by this name
        String sql = String.format("Drop Table %s",tempTable);
        try {
            MySql.getMySql().execute(sql);
        } catch (Exception exc){}
        
        // create the temp table
        sql = String.format(
                "Create Temporary Table %s as (Select * from %s where %s)",
                tempTable,sourceTable,whereClause(conds,and));
        PreparedStatement state = MySql.getMySql().getStatement(sql);

        int i =1;
        for (FilterCondition cond : conds){
            if (!cond.getValue().equals("null")){
                state.setObject(i, cond.getValue());
                ++i;
            }
        }
        state.execute();
    }
    private String whereClause(List<FilterCondition> list,boolean and){
        String connect = " and ";
        if (!and){ 
            connect = " or ";
        }
        boolean first = true;
        StringBuilder builder = new StringBuilder();
        for (FilterCondition cond : list){
            String phrase;
            if (cond.getValue().equals("null")){
                if (cond.getOp().equals("=")){
                    phrase = String.format(" (%s is null ) ", cond.getField(),cond.getField());
                }else {
                    phrase = String.format(" not (%s is null) ", cond.getField(),cond.getField());
                } 
            }else {
                phrase = String.format(" %s %s ? ", cond.getField(),cond.getOp());
            }
            
            
            if (!first){
                builder.append(connect);
            }
            builder.append(phrase);
            first = false;
        }
        return builder.toString();
    }
    public JTable display()throws Exception{
        String[] fields = fieldList();
        DefaultTableModel model = new DefaultTableModel();
        for (String field : fields){
            model.addColumn(field);
        }
        
        Object[] data = new Object[fields.length];
        String sql = String.format("Select * from %s",tempTable);
        ResultSet rs = MySql.getMySql().execute(sql);
        recCount = 0;
        while (rs.next()){
            for (int c=0 ; c < data.length ; ++c){
                String d = rs.getString(fields[c]);
                if (d != null) {
                    data[c] = rs.getString(fields[c]);
                } else {
                    data[c] = "null";
                }
                
            }
            ++recCount;
            model.addRow(data);
        }
        JTable table = new JTable(model);
        table.setAutoCreateRowSorter(true);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);        
        table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        table.setFillsViewportHeight(true);
        return table;
    }
    private String[] fieldList()throws Exception {
        String sql = String.format("select column_name from information_schema.columns where table_name=\'%s\' order by column_name", sourceTable);
        ResultSet rs = MySql.getMySql().execute(sql);   
        ArrayList<String> ret = new ArrayList<>();
        while (rs.next()){
            ret.add(rs.getString("column_name"));
        }
        return ret.toArray(new String[0]);
    }
    public String getTempTable(){
        return this.tempTable;
    }
    public int getCount(){
        return this.recCount;
    }
    int recCount;
    String sourceTable;
    String tempTable;
}
