/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis;

import java.util.List;
import java.util.Random;

/**
 *
 * @author gevirl
 */
// encapsulates all the information accumulated about an individual bomb event
// a bomb event is the bombing of a single construct on a given date
public class BombEvent {
    public BombEvent(){
        if (rand==null) rand = new Random();
    }
    public BombEvent(String id,String gene,List<BombEvent> others){
        this();
        bombID = id;
        this.others = others;
        this.gene = gene;
    }
    public void setDauers(int dauers){
        this.dauers = dauers;
    }
    public Integer getDauers(){
        return this.dauers;
    }    
    public void setIntegrations(int integrations){
        this.integrations = integrations;
    }
    public Integer getIntegrations(){
        return this.integrations;
    }   

    public String GeneName(){
        return this.gene;
    }
    public double getDauersNormalized(){
        return (double)dauers/(double)others.size();
    }
    public double getIntegrationsNormalized (){
        return (double)integrations/(double)others.size();
    }
    public void setDNAConc(double conc){
        DNAConc = conc;
    }
    public Double getDNAConc(){
        return this.DNAConc;
    }
    public void setFosmidSize(int size){
        this.fosmidSize = size;
    }
    public Integer getFosmidSize(){
        return this.fosmidSize;
    }
    public Integer getGeneLocationInFosmid(){
        return geneLoc;
    }
    public void setGeneLocationInFosmid(int loc){
        this.geneLoc = loc;
    }
    public void setGeneSize(int size){
        this.geneSize = size;
    }
    public Integer getGeneSize(){
        return this.geneSize;
    }
    public Double getNoisyDauers(){
        return (double)dauers+0.5*rand.nextGaussian();
    }
    public Double getNoisyIntegrations(){
        return (double)integrations + 0.5*rand.nextGaussian();
    }
    public void setNoisyDauers(double d){
        
    }
    public void setNoisyIntegrations(double i){
        
    }
    static Random rand;
    String bombID;
    String gene;
    Integer dauers;
    Integer integrations;
    Double DNAConc;
    Integer fosmidSize;
    Integer geneLoc;
    Integer geneSize;
    List<BombEvent> others;  // all the bomb events on the same date
//    int constructSize;
//   int geneSize;
}
